% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/controls.R
\name{add_navigation_control}
\alias{add_navigation_control}
\title{Add a navigation control to a map}
\usage{
add_navigation_control(
  map,
  show_compass = TRUE,
  show_zoom = TRUE,
  visualize_pitch = FALSE,
  position = "top-right",
  orientation = "vertical"
)
}
\arguments{
\item{map}{A map object created by the \code{mapboxgl} or \code{maplibre} functions.}

\item{show_compass}{Whether to show the compass button.}

\item{show_zoom}{Whether to show the zoom-in and zoom-out buttons.}

\item{visualize_pitch}{Whether to visualize the pitch by rotating the X-axis of the compass.}

\item{position}{The position on the map where the control will be added. Possible values are "top-left", "top-right", "bottom-left", and "bottom-right".}

\item{orientation}{The orientation of the navigation control. Can be "vertical" (default) or "horizontal".}
}
\value{
The updated map object with the navigation control added.
}
\description{
Add a navigation control to a map
}
\examples{
\dontrun{
library(mapgl)

mapboxgl() |>
    add_navigation_control(visualize_pitch = TRUE)
}
}
