% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_irps.R
\docType{data}
\name{irps_wwi}
\alias{irps_wwi}
\title{One-mode signed network of relationships between European major powers (Antal et al. 2006)}
\format{
\if{html}{\out{<div class="sourceCode">}}\preformatted{#> -- # World War I Protagonists --------------------------------------------------
#> # A dynamic, labelled, signed, undirected network of 6 European major powers
#> and 20 relationship ties from 1872 to 1918
#> 
#> -- Nodes
#> # A tibble: 6 x 1
#>   name 
#>   <chr>
#> 1 GBR  
#> 2 FRA  
#> 3 RUS  
#> 4 AUH  
#> 5 DEU  
#> 6 ITA
#> 
#> -- Ties
#> # A tibble: 20 x 5
#>    from    to  sign begin   end
#>   <int> <int> <dbl> <dbl> <dbl>
#> 1     1     2    -1  1872  1904
#> 2     1     3    -1  1872  1907
#> 3     1     4    -1  1872  1918
#> 4     2     3    -1  1872  1890
#> 5     2     4    -1  1872  1918
#> 6     2     5    -1  1872  1918
#> # i 14 more rows
#> 
}\if{html}{\out{</div>}}
}
\usage{
data(irps_wwi)
}
\description{
This network records the evolution of the major relationship changes
between the protagonists of World War I (WWI) from 1872 to 1907.
It is incomplete both in terms of (eventual) parties to the war as well
as some other relations, but gives a good overview of the main alliances
and enmities.

The data series begins with the Three Emperors' League (1872, revived in 1881)
between Germany, Austria-Hungary, and Russia.
The Triple Alliance in 1882 joined Germany, Austria-Hungary, and Italy into
a bloc that lasted until WWI.
A bilateral alliance between Germany and Russia lapsed in 1890,
and a French-Russian alliance developed between 1891-1894.
The Entente Cordiale thawed and then fostered relations between Great Britain
and France in 1904, and a British-Russian agreement in 1907 bound
Great Britain, France, and Russia into the Triple Entente.
}
\references{
Antal, Tibor, Pavel Krapivsky, and Sidney Redner. 2006.
"Social balance on networks: The dynamics of friendship and enmity".
\emph{Physica D} 224: 130-136.
\doi{10.1016/j.physd.2006.09.028}
}
\keyword{datasets}
