% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/measure_diffusion.R
\name{member_diffusion}
\alias{member_diffusion}
\alias{node_in_adopter}
\title{Membership of nodes in a diffusion}
\usage{
node_in_adopter(.data)
}
\arguments{
\item{.data}{An object of a manynet-consistent class:
\itemize{
\item matrix (adjacency or incidence) from \code{{base}} R
\item edgelist, a data frame from \code{{base}} R or tibble from \code{{tibble}}
\item igraph, from the \code{{igraph}} package
\item network, from the \code{{network}} package
\item tbl_graph, from the \code{{tidygraph}} package
}}
}
\description{
\code{node_in_adopter()} classifies membership of nodes into diffusion categories
by where on the distribution of adopters they fell.
Valente (1995) defines five memberships:
\itemize{
\item \emph{Early adopter}: those with an adoption time less than
the average adoption time minus one standard deviation of adoptions times
\item \emph{Early majority}: those with an adoption time between
the average adoption time and
the average adoption time minus one standard deviation of adoptions times
\item \emph{Late majority}: those with an adoption time between
the average adoption time and
the average adoption time plus one standard deviation of adoptions times
\item \emph{Laggard}: those with an adoption time greater than
the average adoption time plus one standard deviation of adoptions times
\item \emph{Non-adopter}: those without an adoption time,
i.e. never adopted
}
}
\examples{
  smeg <- generate_smallworld(15, 0.025)
  smeg_diff <- play_diffusion(smeg, recovery = 0.2)
  # To classify nodes by their position in the adoption curve
  (adopts <- node_in_adopter(smeg_diff))
  summary(adopts)
}
\references{
\subsection{On adopter classes}{

Valente, Tom W. 1995.
\emph{Network models of the diffusion of innovations}
(2nd ed.). Cresskill N.J.: Hampton Press.
}
}
\seealso{
Other measures: 
\code{\link{measure_attributes}},
\code{\link{measure_central_between}},
\code{\link{measure_central_close}},
\code{\link{measure_central_degree}},
\code{\link{measure_central_eigen}},
\code{\link{measure_closure}},
\code{\link{measure_cohesion}},
\code{\link{measure_diffusion_infection}},
\code{\link{measure_diffusion_net}},
\code{\link{measure_diffusion_node}},
\code{\link{measure_features}},
\code{\link{measure_heterogeneity}},
\code{\link{measure_hierarchy}},
\code{\link{measure_holes}},
\code{\link{measure_periods}},
\code{\link{measure_properties}}

Other diffusion: 
\code{\link{make_play}},
\code{\link{measure_diffusion_infection}},
\code{\link{measure_diffusion_net}},
\code{\link{measure_diffusion_node}}
}
\concept{diffusion}
\concept{measures}
