\name{DT_example}
\alias{DT_example}
\alias{A_example}
\docType{data}
\title{
Broad sense heritability calculation.
}
\description{
This dataset contains phenotpic data for 41 potato lines evaluated in 3 environments in an RCBD design. The phenotypic trait is tuber quality and we show how to obtain an estimate of DT_example for the trait.

}
\usage{data("DT_example")}
\format{
  The format is:
 chr "DT_example"
}
\source{
This data was generated by a potato study.
}
\references{

Giovanny Covarrubias-Pazaran (2024).  lme4breeding: enabling genetic evaluation in the age of genomic data. To be submitted to Bioinformatics.

Douglas Bates, Martin Maechler, Ben Bolker, Steve Walker (2015). Fitting Linear Mixed-Effects Models Using lme4. Journal of Statistical Software, 67(1), 1-48.

}
\examples{

data(DT_example)
DT <- DT_example
A <- A_example
head(DT)

## Compound simmetry (CS) model
ans1 <- lmebreed(Yield~Env + (1|Name) + (1|Env:Name),
             data=DT)
vc <- VarCorr(ans1); print(vc,comp=c("Variance"))

BLUP <- ranef(ans1, condVar=TRUE)$Name
SEs <- attr(BLUP, which="postVar")[,,]

\donttest{

## Compound simmetry (CS) + Diagonal (DIAG) model
## with relationship matrix
Z <- with(DT, smm(Env))
csdiagFormula <- paste0( "Yield ~ Env + (", paste(colnames(Z), collapse = "+"), "|| Name)")
for(i in 1:ncol(Z)){DT[,colnames(Z)[i]] <- Z[,i]}
ansCSDG <- lmebreed(as.formula(csdiagFormula),
                    relmat = list(Name = A ),
                    data=DT)
vc <- VarCorr(ansCSDG); print(vc,comp=c("Variance"))

## Compound simmetry (CS) + Diagonal (DIAG) model
## with diagonal residuals
## with relationship matrix
Z <- with(DT, smm(Env))
DT$units <- as.factor(1:nrow(DT))
csdiagFormula <- paste0( "Yield ~ Env",
                        "+(", paste(colnames(Z), collapse = "+"), "|| Name)",
                        "+(0+ ",paste(colnames(Z), collapse = "+"), "|| units)")
for(i in 1:ncol(Z)){DT[,colnames(Z)[i]] <- Z[,i]}
ansCSDG <- lmebreed(as.formula(csdiagFormula),
                    relmat = list(Name = A ),
                    data=DT)
vc <- VarCorr(ansCSDG); print(vc,comp=c("Variance"))

}

}
\keyword{datasets}
\seealso{The core functions of the package \code{\link{lmebreed}} }
