% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HelperFunctions.R
\name{compute_dW_dlambda_wrapper}
\alias{compute_dW_dlambda_wrapper}
\title{Compute Derivative of Penalty Matrix G with Respect to Lambda (Wrapper)}
\usage{
compute_dW_dlambda_wrapper(
  G,
  A,
  GXX,
  Ghalf,
  dG_dlambda,
  dGhalf_dlambda,
  AGAInv,
  nc,
  K,
  parallel,
  cl,
  chunk_size,
  num_chunks,
  rem_chunks
)
}
\arguments{
\item{G}{A list of penalty matrices \eqn{\textbf{G}} for each partition}

\item{A}{Constraint matrix \eqn{\textbf{A}}}

\item{GXX}{List of \eqn{\textbf{G}\textbf{X}^{T}\textbf{X}} products}

\item{Ghalf}{List of \eqn{\textbf{G}^{1/2}} matrices}

\item{dG_dlambda}{List of \eqn{d\textbf{G}/d\lambda} matrices}

\item{dGhalf_dlambda}{List of \eqn{d\textbf{G}^{1/2}/d\lambda} matrices}

\item{AGAInv}{Inverse of \eqn{\textbf{A}^{T}\textbf{G}\textbf{A}}}

\item{nc}{Number of columns}

\item{K}{Number of partitions minus 1 (\eqn{K})}

\item{parallel}{Logical to enable parallel processing}

\item{cl}{Cluster object for parallel computation}

\item{chunk_size}{Size of chunks for parallel processing}

\item{num_chunks}{Number of chunks}

\item{rem_chunks}{Remainder chunks}
}
\value{
Scalar value representing the trace derivative component.
}
\description{
Wrapper function for computing the derivative of the weight matrix w.r.t lambda \eqn{\lambda}.
This involves computing terms related to the derivative of \eqn{1/(1+\textbf{x}^{T}\textbf{U}\textbf{G}\textbf{x})}.
}
\keyword{internal}
