% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/retry_options.R
\docType{class}
\name{RetryOptions}
\alias{RetryOptions}
\title{RetryOptions}
\format{
An \code{R6Class} object
}
\description{
Retry options may be specified as optional argument to \code{write}.
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{retryJitter}}{Maximum number of random milliseconds included in delay. Default is \code{0}.}

\item{\code{retryInterval}}{First retry delay in seconds. Default is \code{5}.}

\item{\code{maxDelay}}{Maximum delay between retries in seconds. Default is \code{125}.}

\item{\code{maxRetryTime}}{Maximum time to spend retrying in seconds. Default is \code{180}.}

\item{\code{maxAttempts}}{Number of retry attempts. Default is \code{5}.}

\item{\code{exponentialBase}}{Base for exponential backoff strategy. Default is \code{2}.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{RetryOptions$new()}}
\item \href{#method-clone}{\code{RetryOptions$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Creates instance of \code{RetryOptions}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RetryOptions$new(
  retryJitter = 0,
  retryInterval = 5,
  maxDelay = 125,
  maxRetryTime = 180,
  maxAttempts = 5,
  exponentialBase = 2,
  ...
)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RetryOptions$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
