% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tableColors.R
\name{getColorPaletteTable}
\alias{getColorPaletteTable}
\title{Get color palette for the tables}
\usage{
getColorPaletteTable(style = c("report", "presentation"))
}
\arguments{
\item{style}{String with style of report. Either 'report' or
'presentation'. By default, the style is 'report'.}
}
\value{
A named vector with hex colors.
}
\description{
This function gets the color palettes for the tables 
specified as global options.
}
\details{
By default, the function returns the palette of the package. 
The user can specify a custom palette by setting the global options.
}
\examples{
# report style (the default)
getColorPaletteTable()
# presentation style
getColorPaletteTable(style = "presentation")
# custom palette
customColorTable <- c('header' = "#FFFFFF",'headerBackground' = "#3F4788FF", 
'body' = "#000000", 'bodyBackground1' = "#D9D9D9", 'bodyBackground2' = "#D9D9D9", 
'footer' = "#000000", 'footerBackground' = "#FFFFFF",'line' = "#FFFFFF")
options(inTextSummaryTable.colors.table.presentation = customColorTable)
getColorPaletteTable("presentation")
}
