% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subjectProfileSummaryPlot.R
\name{subjectProfileSummaryPlot}
\alias{subjectProfileSummaryPlot}
\title{Plot subject summary profile.}
\usage{
subjectProfileSummaryPlot(
  data,
  xVar = NULL,
  xLab = getLabelVar(xVar, labelVars = labelVars),
  xAxisExpand = waiver(),
  xGap = NULL,
  xGapDiffNew = NULL,
  meanVar = "statMean",
  seVar = if ("statSE" \%in\% colnames(data)) "statSE",
  minVar = NULL,
  maxVar = NULL,
  yLab = paste(c(sub("^stat", "", meanVar), if (!is.null(minVar) & !is.null(maxVar)) {
  
      paste0("(", sub("^stat", "", minVar), ", ", sub("^stat", "", maxVar), ")")
 } else
    if (!is.null(seVar)) paste("+-", sub("^stat", "", seVar))), collapse = " "),
  facetVar = NULL,
  facetScale = "free_y",
  colorVar = NULL,
  colorLab = getLabelVar(colorVar, labelVars = labelVars),
  colorPalette = NULL,
  labelVars = NULL,
  useLinetype = TRUE,
  linetypePalette = NULL,
  useShape = TRUE,
  shapePalette = NULL,
  jitter = NULL,
  title = NULL,
  caption = NULL,
  yTrans = NULL,
  yLim = NULL,
  xLim = NULL,
  yAxisExpand = c(0.05, 0.05),
  yLimExpand = NULL,
  xAxisLabs = NULL,
  sizePoint = 1.5,
  sizeLine = 0.5,
  sizeLabel = 3.87,
  widthErrorBar = 0.9,
  tableText = NULL,
  tableTextFontface = 1,
  tableHeight = 0.1,
  tableYAxisLabs = !is.null(colorVar),
  tablePlotMargin = unit(0, "pt"),
  label = FALSE,
  labelPadding = unit(1, "lines"),
  byVar = NULL,
  hLine = NULL,
  hLineColor = "black",
  hLineLty = "solid",
  vLine = NULL,
  vLineColor = "black",
  vLineLty = "solid",
  style = "report",
  fontname = switch(style, report = "Times", presentation = "Tahoma"),
  fontsize = switch(style, report = 8, presentation = 10),
  themeFct = switch(style, report = theme_classic, presentation = theme_bw),
  themeIncludeVerticalGrid = TRUE,
  ggExtra = NULL,
  legendPosition = ifelse(!is.null(tableText), "none", "bottom"),
  ...
)
}
\arguments{
\item{data}{Data.frame with summary statistics to represent in the plot,
e.g. a \code{\link{summaryTable}} object.}

\item{xVar}{String, variable of \code{data} with variable for the x-axis.}

\item{xLab}{String with label for the \code{xVar}.}

\item{xAxisExpand}{Object passed to the 'expand' parameter of:
\code{\link[ggplot2]{scale_x_continuous}},
(\code{\link[ggplot2]{waiver}} by default).}

\item{xGap}{(optional) Numeric vector of length 2 for which
a gap should be created in the x-axis.
Only available if \code{xVar} is specified and a numeric variable.
Records with \code{xVar} within \code{xGap} are filtered from the plot,
vertical lines are included at the min/max of the gap,
and the gap is represented as '//' in the x-axis of the plot.}

\item{xGapDiffNew}{Numeric vector of length 2 with new range
of the \code{xGap}. If not specified, the minimum difference between
consecutive x elements in the data is used.}

\item{meanVar}{String, variable of \code{data} with the mean variable.}

\item{seVar}{String, variable of \code{data} with the standard error.}

\item{minVar, maxVar}{String, variables of \code{data} with minimum and
maximum value for error bar. 
If both are specified, \code{seVar} is ignored.}

\item{yLab}{String with label for the y-axis.
If different labels should be used for different elements of
\code{byVar} variable, the vector should be named
with each corresponding element (collapsed with '.' if multiple).}

\item{facetVar}{Character vector, variable(s) of \code{data} for facetting.}

\item{facetScale}{String with type of scale used for facetting, 'free_y' by default
(fixed scale in the x-axis and free in the y-axis).}

\item{colorVar}{String, variable of \code{data} for coloring.}

\item{colorLab}{String, label for \code{colorVar}, used in the legend.}

\item{colorPalette}{(named) Vector with color palette.}

\item{labelVars}{Named string with variable labels (names are the variable code).}

\item{useLinetype}{Logical, if TRUE (FALSE by default) use also linetype
to differenciate the variable specified via \code{colorVar} in the mean line.}

\item{linetypePalette}{Vector with linetype(s), in case \code{useLinetype} is TRUE.}

\item{useShape}{Logical, if TRUE (by default) \code{colorVar} is also used for the shape.}

\item{shapePalette}{Named vector with shape palette for \code{colorVar}.}

\item{jitter}{Numeric with jitter for the x-axis, only used if \code{colorVar} specified.}

\item{title}{String with title for the plot.
If different labels should be used for different elements of
\code{byVar} variable, the vector should be named
with each corresponding element (collapsed with '.' if multiple).}

\item{caption}{String with caption for the plot,
NULL by default.}

\item{yTrans}{(optional) String with transformation for the y-axis.
Currently only 'log10' (or NULL, default) is available.
In case error bars go in the negative, their values are set to a 'small enough' value for plotting:
\code{min(data)/10} or \code{yLim[1]} if \code{yLim} is specified.}

\item{yLim}{Vector of the length 2 with limits for the y-axis.}

\item{xLim}{Vector of the length 2 with limits for the x-axis.}

\item{yAxisExpand}{Expansion constants for the limits for the y-axis.
See the documentation of the \code{expand} parameter of the 
\code{\link[ggplot2]{scale_y_continuous}} function
for the available values for this parameter.}

\item{yLimExpand}{This parameter is deprecated, use \code{yAxisExpand}
instead.}

\item{xAxisLabs}{(optional) Named character vector with labels for the x-axis.}

\item{sizePoint}{Size for the point.}

\item{sizeLine}{Size for the line linking means and error bars.}

\item{sizeLabel}{Size for the label, only used if \code{label} is not NULL.}

\item{widthErrorBar}{Numeric vector of length 1 with width of error bar.}

\item{tableText}{(optional) Character vector with colname of \code{data}
or expression from colnames of \code{data} to be represented in
the table below the plot.
By default, no table is displayed.}

\item{tableTextFontface}{Font face for the text included
in the table.}

\item{tableHeight}{Numeric of length 1 with height for the table.}

\item{tableYAxisLabs}{Logical, if TRUE (by default)
the labels of the \code{colorVar} are included
in the y-axis of the table.}

\item{tablePlotMargin}{Margin between the plot and the table,
expressed as \code{\link[grid]{unit}}, 0 by default.}

\item{label}{Logical or expression or list of expression.
Points are labelled with \code{meanVar} if set to TRUE,
or with the specified expression if \code{label} is an expression.
If a list is specified, 'textLabel' (required) 
should contain expression to extract label, 
and 'textHjust' and 'textVjust' (optional) may contain expression 
specifying horizontal and vertical adjustment of the label.}

\item{labelPadding}{Amount of padding (space) between each point
and its \code{label}, 1.5 lines by default.
See parameter \code{point.padding} of the
\code{\link[ggrepel]{geom_text_repel}} function.}

\item{byVar}{Variable(s) of \code{data} for which separated plot(s)
should be created.}

\item{hLine}{(optional) numeric with y-intercept of line(s) to be added.
If different thresholds should be used for different elements of the 
\code{byVar} or \code{facetVar} variables, the vector should be named
with each corresponding element (collapsed with '.' if multiple).}

\item{hLineColor}{String with color for \code{hLine}, 'black' by default.}

\item{hLineLty}{String with linetype for \code{hLine}, 'solid' by default.}

\item{vLine}{(optional) numeric with x-intercept of line(s) to be added.
If different thresholds should be used for different elements of the 
\code{byVar} or \code{facetVar} variables, the vector should be named
with each corresponding element (collapsed with '.' if multiple).}

\item{vLineColor}{String with color for \code{vLine}, 'black' by default.}

\item{vLineLty}{String with linetype for \code{vLine}, 'solid' by defaul}

\item{style}{String with subject profile style.
This affects the parameters: \code{fontname}, \code{fontsize}
and \code{themeFct}.}

\item{fontname}{String with font name,
by default 'Times' if \code{style} is 'report' and
'Tahoma' if \code{style} is 'presentation'.}

\item{fontsize}{Numeric vector of length 1 with font size,
by default 8 if \code{style} is 'report' and
10 if \code{style} is 'presentation'}

\item{themeFct}{Function with ggplot2 theme,
by default \code{\link[ggplot2]{theme_classic}} if \code{style} is 'report' and
\code{\link[ggplot2]{theme_bw}} if \code{style} is 'presentation'.}

\item{themeIncludeVerticalGrid}{Logical, if TRUE (by default)
include theme vertical grid lines (if present in \code{themeFct}).}

\item{ggExtra}{Extra \code{ggplot} call of function generating such call(s)
to be added in main plot.\cr
Multiple calls are set via a function, e.g. 
\code{ggExtra = function(gg){gg + geom_vline(...) + geom_hline(...)}}.\cr
If different calls should be used for different elements of the 
\code{byVar} variable, the vector should be named
with each corresponding element (collapsed with '.' if multiple).}

\item{legendPosition}{String with legend position.
By default, 'bottom' of \code{tableText} is not specified,
'none' otherwise.}

\item{...}{Additional parameters for \code{\link[ggrepel]{geom_text_repel}} or
\code{\link[ggplot2]{geom_text}}
used for the \code{label}.}
}
\value{
\code{\link[ggplot2]{ggplot}} object or list of such
objects of \code{byVar} is specified.
}
\description{
The user can either specify a variable for the standard error
(\code{seVar}),
or directly the variables for the minimum and maximum values for the error
bars (\code{minVar}, \code{maxVar}).
}
\author{
Laure Cougnaud
}
