% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grid.R
\name{gridPage}
\alias{gridPage}
\title{Create a css grid based page}
\usage{
gridPage(..., title = NULL, fill_page = TRUE, dependency = bootstrapLib())
}
\arguments{
\item{...}{Arguments to be passed to \link{gridPanel}.}

\item{title}{The browser window title (defaults to the host URL of the page).}

\item{fill_page}{Boolean value if the page should automatically stretch to
match the browser window height.}

\item{dependency}{A set of web dependencies. This value can be a
\link{htmlDependency}, for example the shiny bootstrap dependency (default
value) or a \link{tagList} with different dependencies.}
}
\value{
A UI definition that can be passed to the \link{shinyUI} function.
}
\description{
Create a Shiny UI page using a \link{gridPanel} to wrap the page content.
As other Shiny UI pages, it scaffolds the entire page and loads any required
or registered dependencies.
}
\note{
See
\url{https://css-tricks.com/snippets/css/complete-guide-grid/}
for additional details on using css grids.
}
\seealso{
\link{gridPanel}
}
\concept{grid functions}
\keyword{grid}
\keyword{page}
