% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make.R
\encoding{UTF-8}
\name{make_graph}
\alias{make_graph}
\alias{make_directed_graph}
\alias{make_undirected_graph}
\alias{directed_graph}
\alias{undirected_graph}
\title{Create an igraph graph from a list of edges, or a notable graph}
\usage{
make_graph(
  edges,
  ...,
  n = max(edges),
  isolates = NULL,
  directed = TRUE,
  dir = directed,
  simplify = TRUE
)

make_directed_graph(edges, n = max(edges))

make_undirected_graph(edges, n = max(edges))

directed_graph(...)

undirected_graph(...)
}
\arguments{
\item{edges}{A vector defining the edges, the first edge points
from the first element to the second, the second edge from the third
to the fourth, etc. For a numeric vector, these are interpreted
as internal vertex ids. For character vectors, they are interpreted
as vertex names.

Alternatively, this can be a character scalar, the name of a
notable graph. See Notable graphs below. The name is case
insensitive.

Starting from igraph 0.8.0, you can also include literals here,
via igraph's formula notation (see \code{\link[=graph_from_literal]{graph_from_literal()}}).
In this case, the first term of the formula has to start with
a \sQuote{\code{~}} character, just like regular formulae in R.
See examples below.}

\item{...}{For \code{make_graph()}: extra arguments for the case when the
graph is given via a literal, see \code{\link[=graph_from_literal]{graph_from_literal()}}.
For \code{directed_graph()} and \code{undirected_graph()}:
Passed to \code{make_directed_graph()} or \code{make_undirected_graph()}.}

\item{n}{The number of vertices in the graph. This argument is
ignored (with a warning) if \code{edges} are symbolic vertex names. It
is also ignored if there is a bigger vertex id in \code{edges}. This
means that for this function it is safe to supply zero here if the
vertex with the largest id is not an isolate.}

\item{isolates}{Character vector, names of isolate vertices,
for symbolic edge lists. It is ignored for numeric edge lists.}

\item{directed}{Whether to create a directed graph.}

\item{dir}{It is the same as \code{directed}, for compatibility.
Do not give both of them.}

\item{simplify}{For graph literals, whether to simplify the graph.}
}
\value{
An igraph graph.
}
\description{
Create an igraph graph from a list of edges, or a notable graph
}
\section{Notable graphs}{


\code{make_graph()} can create some notable graphs. The name of the
graph (case insensitive), a character scalar must be supplied as
the \code{edges} argument, and other arguments are ignored. (A warning
is given is they are specified.)

\code{make_graph()} knows the following graphs: \describe{
\item{Bull}{The bull graph, 5 vertices, 5 edges, resembles to the head
of a bull if drawn properly.}
\item{Chvatal}{This is the smallest triangle-free graph that is
both 4-chromatic and 4-regular. According to the Grunbaum conjecture there
exists an m-regular, m-chromatic graph with n vertices for every m>1 and
n>2. The Chvatal graph is an example for m=4 and n=12. It has 24 edges.}
\item{Coxeter}{A non-Hamiltonian cubic symmetric graph with 28 vertices and
42 edges.}
\item{Cubical}{The Platonic graph of the cube. A convex regular
polyhedron with 8 vertices and 12 edges.}
\item{Diamond}{A graph with 4 vertices and 5 edges, resembles to a
schematic diamond if drawn properly.}
\item{Dodecahedral, Dodecahedron}{Another Platonic solid with 20 vertices
and 30 edges.}
\item{Folkman}{The semisymmetric graph with minimum number of
vertices, 20 and 40 edges. A semisymmetric graph is regular, edge transitive
and not vertex transitive.}
\item{Franklin}{This is a graph whose embedding
to the Klein bottle can be colored with six colors, it is a counterexample
to the necessity of the Heawood conjecture on a Klein bottle. It has 12
vertices and 18 edges.}
\item{Frucht}{The Frucht Graph is the smallest
cubical graph whose automorphism group consists only of the identity
element. It has 12 vertices and 18 edges.}
\item{Grotzsch}{The Groetzsch
graph is a triangle-free graph with 11 vertices, 20 edges, and chromatic
number 4. It is named after German mathematician Herbert Groetzsch, and its
existence demonstrates that the assumption of planarity is necessary in
Groetzsch's theorem that every triangle-free planar graph is 3-colorable.}
\item{Heawood}{The Heawood graph is an undirected graph with 14 vertices and
21 edges. The graph is cubic, and all cycles in the graph have six or more
edges. Every smaller cubic graph has shorter cycles, so this graph is the
6-cage, the smallest cubic graph of girth 6.}
\item{Herschel}{The Herschel
graph is the smallest nonhamiltonian polyhedral graph. It is the unique such
graph on 11 nodes, and has 18 edges.}
\item{House}{The house graph is a
5-vertex, 6-edge graph, the schematic draw of a house if drawn properly,
basicly a triangle of the top of a square.}
\item{HouseX}{The same as the
house graph with an X in the square. 5 vertices and 8 edges.}
\item{Icosahedral, Icosahedron}{A Platonic solid with 12 vertices and 30
edges.}
\item{Krackhardt kite}{A social network with 10 vertices and 18
edges.  Krackhardt, D. Assessing the Political Landscape: Structure,
Cognition, and Power in Organizations.  Admin. Sci. Quart. 35, 342-369,
1990.}
\item{Levi}{The graph is a 4-arc transitive cubic graph, it has 30
vertices and 45 edges.}
\item{McGee}{The McGee graph is the unique 3-regular
7-cage graph, it has 24 vertices and 36 edges.}
\item{Meredith}{The Meredith
graph is a quartic graph on 70 nodes and 140 edges that is a counterexample
to the conjecture that every 4-regular 4-connected graph is Hamiltonian.}
\item{Noperfectmatching}{A connected graph with 16 vertices and 27 edges
containing no perfect matching. A matching in a graph is a set of pairwise
non-adjacent edges; that is, no two edges share a common vertex. A perfect
matching is a matching which covers all vertices of the graph.}
\item{Nonline}{A graph whose connected components are the 9 graphs whose
presence as a vertex-induced subgraph in a graph makes a nonline graph. It
has 50 vertices and 72 edges.}
\item{Octahedral, Octahedron}{Platonic solid
with 6 vertices and 12 edges.}
\item{Petersen}{A 3-regular graph with 10
vertices and 15 edges. It is the smallest hypohamiltonian graph, i.e. it is
non-hamiltonian but removing any single vertex from it makes it
Hamiltonian.}
\item{Robertson}{The unique (4,5)-cage graph, i.e. a 4-regular
graph of girth 5. It has 19 vertices and 38 edges.}
\item{Smallestcyclicgroup}{A smallest nontrivial graph whose automorphism
group is cyclic. It has 9 vertices and 15 edges.}
\item{Tetrahedral,
Tetrahedron}{Platonic solid with 4 vertices and 6 edges.}
\item{Thomassen}{The smallest hypotraceable graph, on 34 vertices and 52
edges. A hypotraceable graph does not contain a Hamiltonian path but after
removing any single vertex from it the remainder always contains a
Hamiltonian path. A graph containing a Hamiltonian path is called traceable.}
\item{Tutte}{Tait's Hamiltonian graph conjecture states that every
3-connected 3-regular planar graph is Hamiltonian.  This graph is a
counterexample. It has 46 vertices and 69 edges.}
\item{Uniquely3colorable}{Returns a 12-vertex, triangle-free graph with
chromatic number 3 that is uniquely 3-colorable.}
\item{Walther}{An identity
graph with 25 vertices and 31 edges. An identity graph has a single graph
automorphism, the trivial one.}
\item{Zachary}{Social network of friendships
between 34 members of a karate club at a US university in the 1970s. See W.
W. Zachary, An information flow model for conflict and fission in small
groups, Journal of Anthropological Research 33, 452-473 (1977).  } }
}

\examples{
make_graph(c(1, 2, 2, 3, 3, 4, 5, 6), directed = FALSE)
make_graph(c("A", "B", "B", "C", "C", "D"), directed = FALSE)

solids <- list(
  make_graph("Tetrahedron"),
  make_graph("Cubical"),
  make_graph("Octahedron"),
  make_graph("Dodecahedron"),
  make_graph("Icosahedron")
)

graph <- make_graph(
  ~ A - B - C - D - A, E - A:B:C:D,
  F - G - H - I - F, J - F:G:H:I,
  K - L - M - N - K, O - K:L:M:N,
  P - Q - R - S - P, T - P:Q:R:S,
  B - F, E - J, C - I, L - T, O - T, M - S,
  C - P, C - L, I - L, I - P
)
}
\seealso{
Other deterministic constructors: 
\code{\link{graph_from_atlas}()},
\code{\link{graph_from_edgelist}()},
\code{\link{graph_from_literal}()},
\code{\link{make_}()},
\code{\link{make_chordal_ring}()},
\code{\link{make_empty_graph}()},
\code{\link{make_full_citation_graph}()},
\code{\link{make_full_graph}()},
\code{\link{make_lattice}()},
\code{\link{make_ring}()},
\code{\link{make_star}()},
\code{\link{make_tree}()}
}
\concept{deterministic constructors}
