% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/community.R
\name{cluster_fluid_communities}
\alias{cluster_fluid_communities}
\title{Community detection algorithm based on interacting fluids}
\usage{
cluster_fluid_communities(graph, no.of.communities)
}
\arguments{
\item{graph}{The input graph. The graph must be simple and connected.
Empty graphs are not supported as well as single vertex graphs.
Edge directions are ignored. Weights are not considered.}

\item{no.of.communities}{The number of communities to be found. Must be
greater than 0 and fewer than number of vertices in the graph.}
}
\value{
\code{cluster_fluid_communities()} returns a \code{\link[=communities]{communities()}}
object, please see the \code{\link[=communities]{communities()}} manual page for details.
}
\description{
The algorithm detects communities based on the simple idea of
several fluids interacting in a non-homogeneous environment
(the graph topology), expanding and contracting based on their
interaction and density.
}
\examples{
g <- make_graph("Zachary")
comms <- cluster_fluid_communities(g, 2)
}
\references{
Parés F, Gasulla DG, et. al. (2018) Fluid Communities: A Competitive,
Scalable and Diverse Community Detection Algorithm. In: Complex Networks
& Their Applications VI: Proceedings of Complex Networks 2017 (The Sixth
International Conference on Complex Networks and Their Applications),
Springer, vol 689, p 229, doi: 10.1007/978-3-319-72150-7_19
}
\seealso{
See \code{\link[=communities]{communities()}} for extracting the membership,
modularity scores, etc. from the results.

Other community detection algorithms: \code{\link[=cluster_walktrap]{cluster_walktrap()}},
\code{\link[=cluster_spinglass]{cluster_spinglass()}},
\code{\link[=cluster_leading_eigen]{cluster_leading_eigen()}},
\code{\link[=cluster_edge_betweenness]{cluster_edge_betweenness()}},
\code{\link[=cluster_fast_greedy]{cluster_fast_greedy()}},
\code{\link[=cluster_label_prop]{cluster_label_prop()}}
\code{\link[=cluster_louvain]{cluster_louvain()}},
\code{\link[=cluster_leiden]{cluster_leiden()}}

Community detection
\code{\link{as_membership}()},
\code{\link{cluster_edge_betweenness}()},
\code{\link{cluster_fast_greedy}()},
\code{\link{cluster_infomap}()},
\code{\link{cluster_label_prop}()},
\code{\link{cluster_leading_eigen}()},
\code{\link{cluster_leiden}()},
\code{\link{cluster_louvain}()},
\code{\link{cluster_optimal}()},
\code{\link{cluster_spinglass}()},
\code{\link{cluster_walktrap}()},
\code{\link{compare}()},
\code{\link{groups}()},
\code{\link{make_clusters}()},
\code{\link{membership}()},
\code{\link{modularity.igraph}()},
\code{\link{plot_dendrogram}()},
\code{\link{split_join_distance}()},
\code{\link{voronoi_cells}()}
}
\author{
Ferran Parés
}
\concept{community}
\keyword{graphs}
