% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/structural.properties.R
\name{shortest.paths}
\alias{shortest.paths}
\title{Shortest (directed or undirected) paths between vertices}
\usage{
shortest.paths(
  graph,
  v = V(graph),
  to = V(graph),
  mode = c("all", "out", "in"),
  weights = NULL,
  algorithm = c("automatic", "unweighted", "dijkstra", "bellman-ford", "johnson")
)
}
\arguments{
\item{graph}{The graph to work on.}

\item{v}{Numeric vector, the vertices from which the shortest paths will be
calculated.}

\item{to}{Numeric vector, the vertices to which the shortest paths will be
calculated. By default it includes all vertices. Note that for
\code{distances()} every vertex must be included here at most once. (This
is not required for \code{shortest_paths()}.}

\item{mode}{Character constant, gives whether the shortest paths to or from
the given vertices should be calculated for directed graphs. If \code{out}
then the shortest paths \emph{from} the vertex, if \verb{in} then \emph{to}
it will be considered. If \code{all}, the default, then the graph is treated
as undirected, i.e. edge directions are not taken into account. This
argument is ignored for undirected graphs.}

\item{weights}{Possibly a numeric vector giving edge weights. If this is
\code{NULL} and the graph has a \code{weight} edge attribute, then the
attribute is used. If this is \code{NA} then no weights are used (even if
the graph has a \code{weight} attribute). In a weighted graph, the length
of a path is the sum of the weights of its constituent edges.}

\item{algorithm}{Which algorithm to use for the calculation. By default
igraph tries to select the fastest suitable algorithm. If there are no
weights, then an unweighted breadth-first search is used, otherwise if all
weights are positive, then Dijkstra's algorithm is used. If there are
negative weights and we do the calculation for more than 100 sources, then
Johnson's algorithm is used. Otherwise the Bellman-Ford algorithm is used.
You can override igraph's choice by explicitly giving this parameter. Note
that the igraph C core might still override your choice in obvious cases,
i.e. if there are no edge weights, then the unweighted algorithm will be
used, regardless of this argument.}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}

\code{shortest.paths()} was renamed to \code{distances()} to create a more
consistent API.
}
\keyword{internal}
