% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spec_energy_trap.R
\name{spec_energy_trap}
\alias{spec_energy_trap}
\title{Creates a specific energy diagram for a trapezoidal channel}
\usage{
spec_energy_trap(
  Q = NULL,
  b = NULL,
  m = NULL,
  y = NULL,
  scale = 3,
  units = c("SI", "Eng")
)
}
\arguments{
\item{Q}{flow rate [\eqn{m^3 s^{-1}}{m^3/s} or \eqn{ft^3 s^{-1}}{ft^3/s}]}

\item{b}{bottom width [\eqn{m}{m} or \eqn{ft}{ft}]}

\item{m}{side slope (H:1) [unitless]}

\item{y}{depth(s) of flow (a numeric vector of length <= 2) [\eqn{m}{m} or \eqn{ft}{ft}] (optional)}

\item{scale}{multiplier (of yc) for axis scales (default is 3)}

\item{units}{character vector that contains the system of units [options are
\code{SI} for International System of Units and \code{Eng} for English (US customary)
units.}
}
\value{
a specific energy diagram
}
\description{
This function plots a specific energy diagram of a trapezoidal
(including rectangular and triangular) channel, with annotation of
critical depth and minimum specific energy.
}
\details{
Specific Energy, E, is the energy, expressed as a head (i.e., the mechanical energy 
per unit weight of the water, with units of length) relative to the channel bottom.
It is calculated as: 
\deqn{E = y+\alpha\frac{Q^{2}}{2g\,A^{2}} = y+\alpha\frac{V^{2}}{2g}}
where \eqn{y} is flow depth, \eqn{A} is the cross-sectional flow area, \eqn{{V}=\frac{Q}{A}}, and 
and \eqn{\alpha} is a kinetic energy correction factor to account for non-uniform velocities across 
the cross-section;  \eqn{\alpha=1.0} in this function (as is commonly assumed).
}
\examples{

# Draw a specific energy diagram for a cross-section with flow 1, width 2, side slope 3:1 (H:V)
spec_energy_trap(Q = 1.0, b = 2.0, m = 3.0, scale = 4, units = "SI")

# Draw the same specific energy diagram adding lines for depths, y = 0.5 and 0.8 m
spec_energy_trap(Q = 1.0, b = 2.0, m = 3.0, scale = 4, y = c(0.5, 0.8), units = "SI")

}
\author{
Ed Maurer
}
