% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-round-config.R
\name{get_round_model_tasks}
\alias{get_round_model_tasks}
\title{Get the model tasks for a given round}
\usage{
get_round_model_tasks(config_tasks, round_id)
}
\arguments{
\item{config_tasks}{a list version of the content's of a hub's \code{tasks.json}
config file, accessed through the \code{"config_tasks"} attribute of a \verb{<hub_connection>}
object or function \code{\link[=read_config]{read_config()}}.}

\item{round_id}{Character string. Round identifier. If the round is set to
\code{round_id_from_variable: true}, IDs are values of the task ID defined in the
round's \code{round_id} property of \code{config_tasks}.
Otherwise should match round's \code{round_id} value in config. Ignored if hub
contains only a single round.}
}
\value{
a list representation of model tasks for a given round.
}
\description{
Get the model tasks for a given round
}
\examples{
hub_path <- system.file("testhubs/simple", package = "hubUtils")
config_tasks <- read_config(hub_path, "tasks")
get_round_model_tasks(config_tasks, round_id = "2022-10-08")
get_round_model_tasks(config_tasks, round_id = "2022-10-15")
}
