% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/httkpop_direct_resample_inner.R
\name{httkpop_direct_resample_inner}
\alias{httkpop_direct_resample_inner}
\title{Inner loop function called by \code{httkpop_direct_resample}.}
\usage{
httkpop_direct_resample_inner(
  nsamp,
  gendernum,
  agelim_months,
  agelim_years,
  reths,
  weight_category,
  gfr_resid_var,
  ckd_epi_race_coeff,
  nhanes_mec_svy
)
}
\arguments{
\item{nsamp}{The desired number of individuals in the virtual population. 
\code{nsamp} need not be provided if \code{gendernum} is provided.}

\item{gendernum}{Optional: A named list giving the numbers of male and female 
individuals to include in the population, e.g. \code{list(Male=100, 
Female=100)}. Default is NULL, meaning both males and females are included, 
in their proportions in the NHANES data. If both \code{nsamp} and 
\code{gendernum} are provided, they must agree (i.e., \code{nsamp} must be
the sum of \code{gendernum}).}

\item{agelim_months}{Optional: A two-element numeric vector giving the minimum
and maximum ages (in months) to include in the population. Default is c(0, 
959), equivalent to the default \code{agelim_years}. If \code{agelim_months}
is provided and \code{agelim_years} is not, agelim_months will override the 
default values of \code{agelim_years}.}

\item{agelim_years}{Optional: A two-element numeric vector giving the minimum 
and maximum ages (in years) to include in the population. Default is 
c(0,79). If \code{agelim_years} is provided and \code{agelim_months} is not,
\code{agelim_years} will override the default value of \code{agelim_months}.}

\item{reths}{Optional: a character vector giving the races/ethnicities to 
include in the population. Default is \code{c('Mexican American','Other 
Hispanic','Non-Hispanic White','Non-Hispanic Black','Other')}, to include 
all races and ethnicities in their proportions in the NHANES data. 
User-supplied vector must contain one or more of these strings.}

\item{weight_category}{Optional: The weight categories to include in the 
population. Default is \code{c('Underweight', 'Normal', 'Overweight', 
'Obese')}. User-supplied vector must contain one or more of these strings.}

\item{gfr_resid_var}{Logical value indicating whether or not to include
residual variability when generating GFR values. (Default is TRUE, passed from
'httkpop_direct_resample'.)}

\item{ckd_epi_race_coeff}{Logical value indicating whether or not to use the
"race coefficient" from the CKD-EPI equation when estimating GFR values.
(Default is FALSE, passed from 'httkpop_direct_resample'.)}

\item{nhanes_mec_svy}{\code{surveydesign} object created from
\code{\link{mecdt}} using \code{\link[survey]{svydesign}} (this is done in
\code{\link{httkpop_generate}})}
}
\value{
A data.table where each row represents an individual, and
 each column represents a demographic, anthropometric, or physiological
 parameter.
}
\description{
Inner loop function called by \code{httkpop_direct_resample}.
}
\references{
\insertRef{ring2017identifying}{httk}
}
\author{
Caroline Ring
}
\keyword{httk-pop}
\keyword{monte-carlo}
