% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate_hematocrit.R
\name{estimate_hematocrit}
\alias{estimate_hematocrit}
\title{Generate hematocrit values for a virtual population}
\usage{
estimate_hematocrit(gender, reth, age_years, age_months, nhanes_mec_svy)
}
\arguments{
\item{gender}{Gender for which to generate hematocrit values ("Male" or
"Female")}

\item{reth}{NHANES race/ethnicity category for which to generate serum
creatinine values ("Mexican American", "Non-Hispanic Black", "Non-Hispanic
White", "Other", or "Other Hispanic")}

\item{age_years}{Vector of ages in years for individuals for whom to generate
hematocrit values (corresponding to age_months)}

\item{age_months}{vector of ages in months for individuals for whom to
generate hematocrit values (between 0-959 months)}

\item{nhanes_mec_svy}{\code{surveydesign} object created from
\code{\link{mecdt}} using \code{\link[survey]{svydesign}} (this is done in
\code{\link{httkpop_generate}})}
}
\value{
A vector of numeric generated hematocrit values (blood percentage red
 blood cells by volume).
}
\description{
Predict hematocrit from age using smoothing splines and kernel density
estimates of residual variability fitted to NHANES data, for a given
combination of gender and NHANES race/ethnicity category.
}
\details{
This function should usually not be called directly by the user. It is used by
\code{httkpop_generate()} in "virtual-individuals" mode, after drawing gender,
NHANES race/ethnicity category, and age from their NHANES
proportions/distributions.
}
\references{
\insertRef{ring2017identifying}{httk}
}
\author{
Caroline Ring
}
\keyword{httk-pop}
