% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apply_clint_adjustment.R
\name{apply_clint_adjustment}
\alias{apply_clint_adjustment}
\title{Correct the measured intrinsive hepatic clearance for fraction free}
\usage{
apply_clint_adjustment(
  Clint,
  Fu_hep = NULL,
  Pow = NULL,
  pKa_Donor = NULL,
  pKa_Accept = NULL,
  suppress.messages = FALSE
)
}
\arguments{
\item{Clint}{In vitro measured intrinsic hepatic clearance in units of
(ul/min/million hepatocytes).}

\item{Fu_hep}{Estimated fraction of chemical free for metabolism in the 
in vitro assay, estimated by default from the method of Kilford et al. (2008)
using \code{\link{calc_hep_fu}}}

\item{Pow}{The octanal:water equilibrium partition coefficient}

\item{pKa_Donor}{A string containing hydrogen donor ionization equilibria, 
concatenated with commas. Can be "NA" if none exist.}

\item{pKa_Accept}{A string containing hydrogen acceptance ionization equilibria, 
concatenated with commas. Can be "NA" if none exist.}

\item{suppress.messages}{Whether or not the output message is suppressed.}
}
\value{
Intrinsic hepatic clearance increased to take into account binding
in the in vitro assay
}
\description{
This function uses the free fraction estimated from Kilford et al. (2008) 
to increase the in vitro measure intrinsic hepatic clearance. The assumption
that chemical that is bound in vitro is not available to be metabolized and
therefore the actual rate of clearance is actually faster. Note that in most
high throughput TK models included in the package this increase is offset by
the assumption of "restrictive clearance" -- that is, the rate of hepatic
metabolism is slowed to account for the free fraction of chemical in plasma.
This adjustment was made starting in Wetmore et al. (2015) in order to better
predict plasma concentrations.
}
\references{
\insertRef{kilford2008hepatocellular}{httk} 
\insertRef{wetmore2015incorporating}{httk}
}
\seealso{
\code{\link{calc_hep_fu}}
}
\author{
John Wambaugh
}
\keyword{in-vitro}
