% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nc.hdqr-methods.R
\name{predict.nc.hdqr}
\alias{predict.nc.hdqr}
\title{Make Predictions from a `nc.hdqr` Object}
\usage{
\method{predict}{nc.hdqr}(object, newx, s = NULL, ...)
}
\arguments{
\item{object}{Fitted `nc.hdqr()` object from which predictions are to be derived.}

\item{newx}{Matrix of new predictor values for which predictions are desired.
This must be a matrix and is a required argument.}

\item{s}{Values of the penalty parameter `lambda` for which predictions are requested.
Defaults to the entire sequence used during the model fit.}

\item{...}{Not used.}
}
\value{
Returns a vector or matrix of predicted values corresponding to the specified `lambda` values.
}
\description{
Produces fitted values for new predictor data using a fitted `nc.hdqr()` object.
}
\details{
This function generates predictions at specified `lambda` values from a fitted `nc.hdqr()` object.
It is essential to provide a new matrix of predictor values (`newx`) at which these predictions are to be made.
}
\examples{
set.seed(315)
n <- 100
p <- 400
x <- matrix(data = rnorm(n * p, mean = 0, sd = 1), nrow = n, ncol = p)
beta_star <- c(c(2, 1.5, 0.8, 1, 1.75, 0.75, 0.3), rep(0, (p - 7)))
eps <- rnorm(n, mean = 0, sd = 1)
y <- x \%*\% beta_star + eps
tau <- 0.5
lam2 <- 0.01
lambda <- 10^(seq(1,-4, length.out=30))
nc.fit <- nc.hdqr(x=x, y=y, tau=tau, lambda=lambda, lam2=lam2, pen="scad")
nc.preds <- predict(nc.fit, newx = tail(x), s = nc.fit$lambda[3:5])
}
\seealso{
\code{\link{nc.hdqr}}, \code{\link{coef.nc.hdqr}}
}
