% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bootjack.R
\name{bootjack}
\alias{bootjack}
\title{Bootstrap-jacknife of flow calibration statistics}
\usage{
bootjack(
  flows,
  GOF_stat = c("NSE", "KGE"),
  nSample = 1000,
  waterYearMonth = 10,
  startYear = NULL,
  endYear = NULL,
  minDays = 100,
  minYears = 10,
  returnSamples = FALSE,
  seed = NULL,
  bootYearFile = NULL
)
}
\arguments{
\item{flows}{Required. Data frame containing the date, observed and simulated
flows. The variable names must be \option{date}, \option{obs}, and \option{sim},
respectively. The \code{date} must be a standard \R date.}

\item{GOF_stat}{Required. Name(s) of simulation goodness of fit statistic(s)
to be calculated. Currently both \code{NSE} and \code{KGE} are supported.}

\item{nSample}{Required. Number of samples for bootstrapping.}

\item{waterYearMonth}{Required. Month of beginning of water year. Default
is \code{10} (October). If the calendar year is required, set
\code{waterYearMonth = 13}.}

\item{startYear}{Optional. First year of data to be used. If \code{NULL}
then not used.}

\item{endYear}{Optional. Last year of data to be used. If \code{NULL} then
not used.}

\item{minDays}{Required. Minimum number of days per year with valid
(i.e. greater than 0) flows. Default is 100.}

\item{minYears}{Required. Minimum number years to be used. Default is 10.}

\item{returnSamples}{Optional. Default is \code{FALSE}. If \code{TRUE}, then
sample statistics are returned. This is primarily used for debugging/testing.}

\item{seed}{Optional. If \code{NULL} (the default) then no seed is specified
for the random number generator used for the bootstrapping. If a value is specified
then the bootstrapping will always use the same set of pseudo-random numbers.}

\item{bootYearFile}{Optional. If \code{NULL} (the default) the years used for
the bootstrapping are neither output nor input. If a file is specified, and it
it does not already exist, then the bootstrap years will be written to a .csv
file as a table with the dimensions of years x nSample. If a file is specified,
and it _does_ exist, then the years will be read in, and used for the bootstrapping.}
}
\value{
Returns a data frame containing the goodness of fit statistic name
(i.e. \option{NSE} and/or \option{KGE}), and \code{seJack} = standard error of
jacknife, \code{seBoot} = standard error of bootstrap, \code{p05, p50, p95},
the 5th, 50th and 95th percentiles of the estimates, \code{score} = jackknife
score, \code{biasJack} = bias of jackknife, \code{biasBoot} = bias of bootstap,
\code{seJab} = standard error of jackknife after bootstrap.
}
\description{
Bootstrap-jacknife of flow calibration statistics
}
\examples{
NSE_stats <- bootjack(flows_1030500, "NSE")
}
\seealso{
\code{\link{read_CAMELS}}
}
\author{
Martyn Clark and Kevin Shook
}
