% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/global_pvalue_fun.R
\name{global_pvalue_fun}
\alias{global_pvalue_fun}
\alias{global_pvalue_fun.default}
\alias{global_pvalue_fun.geeglm}
\title{Global p-value generic}
\usage{
global_pvalue_fun(x, type, ...)

\method{global_pvalue_fun}{default}(x, type, ...)

\method{global_pvalue_fun}{geeglm}(x, type, ...)
}
\value{
data frame
}
\description{
An S3 generic that serves as the default for \code{add_global_p(anova_fun)}.

The default function uses \code{car::Anova()} (via \code{\link[cardx:ard_car_anova]{cardx::ard_car_anova()}}) to
calculate the p-values.

The method for GEE models (created from \code{geepack::geeglm()}) returns Wald tests calculated
using \code{aod::wald.test()} (via \code{\link[cardx:ard_aod_wald_test]{cardx::ard_aod_wald_test()}}). For this method,
the \code{type} argument is not used.
}
\examples{
\dontshow{if ((identical(Sys.getenv("NOT_CRAN"), "true") || identical(Sys.getenv("IN_PKGDOWN"), "true")) && gtsummary:::is_pkg_installed(c("broom", "car", "parameters"))) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
lm(age ~ stage + grade, trial) |>
  global_pvalue_fun(type = "III")
\dontshow{\}) # examplesIf}
}
\keyword{internal}
