% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opts.R
\name{opt_table_lines}
\alias{opt_table_lines}
\title{Option to set table lines to different extents}
\usage{
opt_table_lines(data, extent = c("all", "none", "default"))
}
\arguments{
\item{data}{\emph{The gt table data object}

\verb{obj:<gt_tbl>} // \strong{required}

This is the \strong{gt} table object that is commonly created through use of the
\code{\link[=gt]{gt()}} function.}

\item{extent}{\emph{Extent of lines added}

\verb{singl-kw:[all|none|default]} // \emph{default:} \code{"all"}

The extent to which lines will be visible in the table. Options are
\code{"all"}, \code{"none"}, or \code{"default"}.}
}
\value{
An object of class \code{gt_tbl}.
}
\description{
\code{opt_table_lines()} sets table lines in one of three possible ways:
(1) all possible table lines drawn (\code{"all"}), (2) no table lines at all
(\code{"none"}), and (3) resetting to the default line styles (\code{"default"}). This
is great if you want to start off with lots of lines and subtract just a few
of them with \code{\link[=tab_options]{tab_options()}} or \code{\link[=tab_style]{tab_style()}}. Or, use it to start with a
completely lineless table, adding individual lines as needed.
}
\section{Examples}{


Use the \code{\link{exibble}} dataset to create a \strong{gt} table with a number of table
parts added (using functions like \code{\link[=summary_rows]{summary_rows()}}, \code{\link[=grand_summary_rows]{grand_summary_rows()}},
and more). Following that, we'll use the \code{opt_table_lines()} function to
generate lines everywhere there can possibly be lines (the default for the
\code{extent} argument is \code{"all"}).

\if{html}{\out{<div class="sourceCode r">}}\preformatted{exibble |>
  gt(rowname_col = "row", groupname_col = "group") |>
  summary_rows(
    groups = "grp_a",
    columns = c(num, currency),
    fns = c("min", "max")
  ) |>
  grand_summary_rows(
    columns = currency,
    fns = total ~ sum(., na.rm = TRUE)
  ) |>
  tab_source_note(source_note = "This is a source note.") |>
  tab_footnote(
    footnote = "This is a footnote.",
    locations = cells_body(columns = 1, rows = 1)
  ) |>
  tab_header(
    title = "The title of the table",
    subtitle = "The table's subtitle"
  ) |>
  opt_table_lines()
}\if{html}{\out{</div>}}

\if{html}{\out{
<img src="https://raw.githubusercontent.com/rstudio/gt/master/images/man_opt_table_lines_1.png" alt="This image of a table was generated from the first code example in the `opt_table_lines()` help file." style="width:100\%;">
}}
}

\section{Function ID}{

10-11
}

\section{Function Introduced}{

\code{v0.2.0.5} (March 31, 2020)
}

\seealso{
Other table option functions: 
\code{\link{opt_align_table_header}()},
\code{\link{opt_all_caps}()},
\code{\link{opt_css}()},
\code{\link{opt_footnote_marks}()},
\code{\link{opt_footnote_order}()},
\code{\link{opt_footnote_spec}()},
\code{\link{opt_horizontal_padding}()},
\code{\link{opt_interactive}()},
\code{\link{opt_row_striping}()},
\code{\link{opt_stylize}()},
\code{\link{opt_table_font}()},
\code{\link{opt_table_outline}()},
\code{\link{opt_vertical_padding}()}
}
\concept{table option functions}
