% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transport1d.R
\name{dual1d}
\alias{dual1d}
\title{Dual Solution of one-dimensional Optimal Transport}
\usage{
dual1d(a, b, wa, wb, p = 1, right.margin = 1e-15, sorted = FALSE)
}
\arguments{
\item{a}{first vector of points.}

\item{b}{second vector of points.}

\item{wa}{weight vector of the first vector of points.}

\item{wb}{weight vector of the second vector of points.}

\item{p}{the power \eqn{\geq 1} of the cost function.}

\item{right.margin}{small amount the points are moved by.}

\item{sorted}{logical value indicating whether or not \code{a} and \code{b} are sorted.}
}
\value{
a list containing the dual vectors \code{pot.a} and \code{pot.b}.
}
\description{
Calculate an optimal dual pair for the optimal transport between discrete one-dimensional measures.
}
\details{
The pair \eqn{f, g} is an optimal dual pair if the optimal transport distance between the two distributions
with respect to the cost function \eqn{c(x, y) = | x - y |^p} is given by
\deqn{\langle f, w_a \rangle + \langle g, w_b \rangle}
and the condition \eqn{f_i + g_j \leq | a_i - b_j |^p} holds.
}
\examples{
set.seed(1)
a <- 1:5
wa <- rep(1/5, 5)
b <- 1:6
wb <- runif(6)
wb <- wb / sum(wb)

d <- dual1d(a, b, wa, wb, p = 1)

dc <- sum(d$pot.a * wa) + sum(d$pot.b * wb)
print(all.equal(dc, transport_cost(a, b, wa, wb, p = 1)))
}
