% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cgeneric_treepcor.R
\name{cgeneric_treepcor}
\alias{cgeneric_treepcor}
\title{Build an \code{cgeneric} for \code{\link[=treepcor]{treepcor()}})}
\usage{
cgeneric_treepcor(
  model,
  lambda,
  sigma.prior.reference,
  sigma.prior.probability,
  ...
)
}
\arguments{
\item{model}{object of class \code{treepcor} for the model specification.}

\item{lambda}{the lambda parameter for the graph correlation prior.}

\item{sigma.prior.reference}{a vector with the reference values
to define the prior for the standard deviation parameters.}

\item{sigma.prior.probability}{a vector with the probability values
to define the prior for the standard deviation parameters.}

\item{...}{additional arguments passed on to
\code{\link[INLAtools:cgeneric-class]{INLAtools::cgenericBuilder()}}.}
}
\value{
\code{cgeneric}/\code{cgeneric} object.
}
\description{
This creates an \code{cgeneric} (see \code{\link[INLAtools:cgeneric-class]{INLAtools::cgeneric()}})
containing the necessary data to implement the penalized
complexity prior for a correlation matrix considering
a three as proposed in Sterrantino et. al. 2025
\doi{https://doi.org/10.1007/s10260-025-00788-y}.
}
\details{
The correlation prior as in the paper depends on the lambda value.
The prior for each \eqn{sigma_i} is the Penalized-complexity prior
which can be defined from the following probability statement
P(sigma > U) = a.
where "U" is a reference value and "a" is a probability.
The values "U" and probabilities "a" for each \eqn{sigma_i}
are passed in the \code{sigma.prior.reference} and \code{sigma.prior.probability}
arguments.
If a=0 then U is taken to be the fixed value of the corresponding sigma.
E.g. if there are three sigmas in the model and one supply
sigma.prior.reference = c(1, 2, 3) and
sigma.prior.probability = c(0.05, 0.0, 0.01)
then the sigma is fixed to 2 and not estimated.
}
\seealso{
\code{\link[=treepcor]{treepcor()}} and \code{\link[INLAtools:cgeneric-class]{INLAtools::cgeneric()}}
}
