% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/methods-vclMatrix.R, R/methods.R
\docType{methods}
\name{block}
\alias{block}
\alias{block,vclMatrix,integer,integer,integer,integer-method}
\alias{block,gpuMatrix,integer,integer,integer,integer-method}
\title{Matrix Blocks}
\usage{
block(object, rowStart, rowEnd, colStart, colEnd)

\S4method{block}{vclMatrix,integer,integer,integer,integer}(object, rowStart, rowEnd, colStart, colEnd)

\S4method{block}{gpuMatrix,integer,integer,integer,integer}(object, rowStart, rowEnd, colStart, colEnd)
}
\arguments{
\item{object}{A \code{gpuMatrix} or \code{vclMatrix} object}

\item{rowStart}{An integer indicating the first row of block}

\item{rowEnd}{An integer indicating the last row of block}

\item{colStart}{An integer indicating the first column of block}

\item{colEnd}{An integer indicating the last column of block}
}
\value{
A block of the input \code{gpuMatrixBlock} or \code{vclMatrixBlock} object.
}
\description{
This doesn't create a copy, it provides a child class that
points to a contiguous submatrix of a \code{\link{gpuMatrix}} or
\code{\link{vclMatrix}}.  Non-contiguous blocks are currently not supported.
}
\details{
This function allows a user to create a gpuR matrix object that
references a continuous subset of columns and rows of another gpuR matrix
object without a copy.  

NOTE - this means that altering values in a matrix block object will alter
values in the source matrix.
}
\author{
Charles Determan Jr.
}
