% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{simulate_new}
\alias{simulate_new}
\title{Simulate from covariate/metadata in the absence of a real data set (EXPERIMENTAL)}
\usage{
simulate_new(
  object,
  nsim = 1,
  seed = NULL,
  family = gaussian,
  newdata,
  newparams,
  ...,
  return_val = c("sim", "pars", "object")
)
}
\arguments{
\item{object}{a \emph{one-sided} model formula (e.g. \code{~ a + b + c}
(peculiar naming is for consistency with the generic function, which typically
takes a fitted model object)}

\item{nsim}{number of simulations}

\item{seed}{random-number seed}

\item{family}{a family function, a character string naming a family function, or the result of a call to a family function (variance/link function) information. See \code{\link{family}} for a generic discussion of families or \code{\link{family_glmmTMB}} for details of \code{glmmTMB}-specific families.}

\item{newdata}{a data frame containing all variables listed in the formula,
\emph{including} the response variable (which needs to fall within
the domain of the conditional distribution, and should probably not
be all zeros, but whose value is otherwise irrelevant)}

\item{newparams}{a list of parameters containing sub-vectors
(\code{beta}, \code{betazi}, \code{betadisp}, \code{theta}, etc.) to
be used in the model. If \code{b} is specified in this list, then the conditional modes/BLUPs
will be set to these values; otherwise they will be drawn from the appropriate Normal distribution.
See \code{vignette("covstruct", package = "glmmTMB")} for details on the parameterizations used
for various random-effects models (i.e., \code{theta}).}

\item{...}{other arguments to \code{glmmTMB} (e.g. \code{family})}

\item{return_val}{what information to return: "sim" (the default) returns a list of vectors of simulated outcomes; "pars" returns the default parameter vector (this variant does not require \code{newparams} to be specified, and is useful for figuring out the appropriate dimensions of the different parameter vectors); "object" returns a fake \code{glmmTMB} object (useful, e.g., for retrieving the Z matrix (\code{getME(simulate_new(...), "Z")}) or covariance matrices (\code{VarCorr(simulate_new(...))}) implied by a particular set of input data and parameter values)}
}
\description{
See \code{vignette("sim", package = "glmmTMB")} for more details and examples,
and \code{vignette("covstruct", package = "glmmTMB")}
for more information on the parameterization of different covariance structures.
}
\details{
Use the \code{weights} argument to set the size/number of trials per observation for binomial-type models; the default is 1 for every observation (i.e., Bernoulli trials)
}
\examples{
## use Salamanders data for observational design and covariate values
## parameters used here are sensible, but do not fit the original data
params <- list(beta = c(2, 1),
               betazi = c(-0.5, 0.5), ## logit-linear model for zi
               betadisp = log(2), ## log(NB dispersion)
               theta = log(1)) ## log(among-site SD)
sim_count <- simulate_new(~ mined + (1|site),
             newdata = Salamanders,
             zi = ~ mined,
             family = nbinom2,
             seed = 101,
             newparams = params
)
## simulate_new with return="sim" always returns a list of response vectors
Salamanders$sim_count <- sim_count[[1]]    
summary(glmmTMB(sim_count ~ mined + (1|site), data=Salamanders, ziformula=~mined, family=nbinom2))
## return a glmmTMB object
sim_obj <- simulate_new(~ mined + (1|site),
            return_val = "object",
             newdata = Salamanders,
             zi = ~ mined,
             family = nbinom2,
             newparams = params)
## simulate Gaussian data, multivariate random effect
data("sleepstudy", package = "lme4")
sim_obj <- simulate_new(~ 1 + (1|Subject) + ar1(0 + factor(Days)|Subject),
             return_val = "pars",
             newdata = sleepstudy,
             family = gaussian,
             newparams = list(beta = c(280, 1),
                         betad = log(2), ## log(residual std err)
                         theta = c(log(2), ## log(SD(subject))
                                   log(2), ## log(SD(slope))
                                   ## AR1 correlation = 0.2
                                   put_cor(0.2, input_val = "vec"))
                         )
)

}
\seealso{
\code{\link{glmmTMB}}, \code{\link{family_glmmTMB}} (for conditional distribution parameterizations [\code{betadisp}]), \code{\link{put_cor}} (for correlation matrix parameterizations)
}
