% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/girafe.R
\name{girafeOutput}
\alias{girafeOutput}
\title{Create a girafe output element}
\usage{
girafeOutput(outputId, width = "100\%", height = NULL)
}
\arguments{
\item{outputId}{output variable to read the girafe from. Do not use special JavaScript
characters such as a period \code{.} in the id, this would create a JavaScript error.}

\item{width}{widget width, its default value is set so that the graphic can
cover the entire available horizontal space.}

\item{height}{widget height, its default value is NULL so that width
adaptation is not restricted. The height will then be defined according
to the width used and the aspect ratio. Only use a value for the height
if you have a specific reason and want to strictly control the size.}
}
\description{
Render a girafe within an application page.
}
\section{Size control}{

If you want to control a fixed size, use
\code{opts_sizing(rescale = FALSE)} and set the chart size
with \code{girafe(width_svg=..., height_svg=...)}.

If you want
the graphic to fit the available width,
use \code{opts_sizing(rescale = TRUE)} and set the size of the
graphic with \code{girafe(width_svg=..., height_svg=...)}, this
size will define the aspect ratio.
}

