% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggiraph-documentation-with-examples.R
\name{gf_area_interactive}
\alias{gf_area_interactive}
\title{Interactive area plots}
\arguments{
\item{object}{When chaining, this holds an object produced in the earlier portions
of the chain. Most users can safely ignore this argument.}

\item{gformula}{A formula with shape \code{y ~ x}. Faceting can be achieved by
including \code{|} in the formula.}

\item{data}{The data to be displayed in this layer.}

\item{tooltip}{A formula specifying a variable for tooltips, or a character vector.}

\item{data_id}{A formula or character vector specifying data identifiers
for interactive selection.}

\item{...}{Additional arguments passed to the underlying geom.}

\item{alpha, color, size, shape, fill, group, stroke}{Aesthetics passed to the geom.}

\item{xlab, ylab, title, subtitle, caption}{Labels for the plot.}

\item{show.legend}{Logical. Should this layer be included in the legends?}

\item{show.help}{Logical. If \code{TRUE}, display some minimal help.}

\item{inherit}{Logical. If \code{TRUE}, inherit aesthetics from previous layers.}

\item{environment}{An environment in which to evaluate the formula.}
}
\value{
A gg object that can be displayed with \code{\link[=gf_girafe]{gf_girafe()}}.
}
\description{
Creates an interactive plot using ggiraph. This function extends
\code{\link[=gf_area]{gf_area()}} with interactive features like tooltips and clickable elements.
}
\section{Additional interactive features}{

\itemize{
\item \code{onclick}: JavaScript code (as character string) executed when clicking elements.
\item Additional ggiraph aesthetics may be available depending on the geom.
}
}

\examples{
Huron <-
  data.frame(
    year = 1875:1972,
    level = as.vector(LakeHuron)
  )

Huron |>
  gf_area_interactive(
    level ~ year,
    tooltip = ~ "This is the area.",
    data_id = "id:area",
    fill = "skyblue"
    ) |>
  gf_line_interactive(
    tooltip = ~ "This is the line.",
    data_id = "id:line"
  ) |>
  gf_girafe(
    list(
      options = list(opts_tooltip(css = "fill: steelblue;"))
    )
  )

}
\seealso{
\code{\link[=gf_area]{gf_area()}}, \code{\link[=gf_girafe]{gf_girafe()}}
}
