% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dput.ggedit.R
\name{dput.ggedit}
\alias{dput.ggedit}
\title{Convert ggplot object to a string call}
\usage{
dput.ggedit(obj, file = "")
}
\arguments{
\item{obj}{compiled ggplot object}

\item{file}{either a character string naming a file or a \link{connection}. " " indicates output to the console, Default: " "}
}
\value{
character
}
\description{
Convert ggplot object to a string call
}
\examples{

 pList$pointSmooth #original compiled plot
 
 this.gg <- dput.ggedit(pList$pointSmooth) #dput the plot
 
 writeLines(this.gg) #show the output
 
 eval(parse(text=this.gg)) #recompile the plot

 #add theme change
 p <- pList$pointSmooth+theme(panel.background = element_rect(fill='green'))
 
 this.gg<-dput.ggedit(p) #dput the plot
 
 writeLines(this.gg) #show the output
 
 eval(parse(text=this.gg)) #recompile the plot

}
