% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/alignpatch-patch.R
\name{patch.Heatmap}
\alias{patch.Heatmap}
\alias{patch.HeatmapList}
\alias{patch.HeatmapAnnotation}
\title{Convert Object into a Grob}
\usage{
\method{patch}{Heatmap}(x, ..., device = NULL)

\method{patch}{HeatmapList}(x, ..., device = NULL)

\method{patch}{HeatmapAnnotation}(x, ..., device = NULL)
}
\arguments{
\item{x}{An object to be converted into a \code{\link[grid:grid.grob]{grob}}.}

\item{...}{Additional arguments passed to \link[ComplexHeatmap:draw-dispatch]{draw()}.}

\item{device}{ A function that opens a graphics device for temporary
    rendering. By default this is an off-screen, in-memory device
    based on the \code{pdf} device, but this default device may not be
    satisfactory when using custom fonts.
  }
}
\value{
A \code{\link[grid:grid.grob]{grob}} object.
}
\description{
The \code{patch()} function is used by \code{\link[=ggwrap]{ggwrap()}} and \code{\link[=inset]{inset()}} to convert
objects into a \code{\link[grid:grid.grob]{grob}}.
}
\seealso{
\itemize{
\item \code{\link[ComplexHeatmap:Heatmap]{Heatmap()}}
\item \code{\link[ComplexHeatmap:HeatmapAnnotation]{HeatmapAnnotation()}}
}

Other \code{\link[=patch]{patch()}} methods:
\code{\link{patch.alignpatches}()},
\code{\link{patch.formula}()},
\code{\link{patch.ggplot}()},
\code{\link{patch.grob}()},
\code{\link{patch.patch}()},
\code{\link{patch.patch_ggplot}()},
\code{\link{patch.patchwork}()},
\code{\link{patch.pheatmap}()},
\code{\link{patch.recordedplot}()},
\code{\link{patch.trellis}()}
}
\concept{patch}
