% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layout-chain-stack-cross.R
\name{stack_cross}
\alias{stack_cross}
\alias{stack_crossv}
\alias{stack_crossh}
\title{Arrange plots crosswise horizontally or vertically}
\usage{
stack_cross(direction, data = NULL, ..., theme = NULL, sizes = NA)

stack_crossv(data = NULL, ...)

stack_crossh(data = NULL, ...)
}
\arguments{
\item{direction}{A string indicating the direction of the stack layout,
either \code{"h"}(\code{horizontal}) or \code{"v"}(\code{vertical}).}

\item{data}{Default dataset to use for the layout. If not specified, it must be supplied in each plot added to the layout, \code{\link[=fortify_matrix]{fortify_matrix()}} will be used to
convert the data to a matrix.}

\item{...}{Additional arguments passed to \code{\link[=fortify_matrix]{fortify_matrix()}}.}

\item{theme}{A \code{\link[ggplot2:theme]{theme()}} object used to customize various
elements of the layout, including \code{guides}, \code{title}, \code{subtitle}, \code{caption},
\code{margins}, \code{panel.border}, and \code{background}. By default, the theme will
inherit from the parent \code{layout}. It also controls the panel spacing for all
plots in the layout.}

\item{sizes}{A numeric value or a \code{\link[grid:unit]{unit}} object. When used for
the \code{\link[=quad_layout]{quad_layout()}} annotation, it must be of length \code{1}. When used in the
\code{\link[=stack_layout]{stack_layout()}} with a nested \code{\link[=quad_layout]{quad_layout()}}, it should be of length
\code{3}, specifying the relative heights (for \code{direction = "h"}) or widths (for
\code{direction = "v"}) to be applied to the layout.}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

The \code{stack_cross} function is derived from \code{\link[=stack_discrete]{stack_discrete()}} and allows
for different layout ordering indices within a single layout.

Two aliases are provided for convenience:
\itemize{
\item \code{stack_crossv}: A special case of \code{stack_cross} that sets
\code{direction = "v"} for vertical alignment.
\item \code{stack_crossh}: A special case of \code{stack_cross} that sets
\code{direction = "h"} for horizontal alignment.
}
}
\seealso{
\code{\link[=ggcross]{ggcross()}}
}
