% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makeLSPs.R
\name{makeCrv}
\alias{makeCrv}
\title{makeCrv}
\usage{
makeCrv(
  dtm,
  cellSize = 1,
  mode = "mean",
  smoothRadius = 7,
  writeRaster = FALSE,
  outName,
  device = "cpu"
)
}
\arguments{
\item{dtm}{Input SpatRaster object representing bare earth surface elevations.}

\item{cellSize}{Resolution of raster grid. Default is 1 m.}

\item{mode}{"mean", "profile", or "planform". Default is "mean".}

\item{smoothRadius}{radius of circular moving window. Default is 7 cells.}

\item{writeRaster}{TRUE or FALSE. Save output to disk. Default is TRUE.}

\item{outName}{Name of output raster with full file path and extension.}

\item{device}{"cpu" or "cuda". Use "cuda" for GPU computation. Without using the GPU,
implementation will not be significantly faster than using non-tensor-based computation.
Defaults is "cpu".}
}
\description{
Calculate surface curvatures from input digital terrain model (DTM) using torch
}
\details{
Calculate surface curvatures from input digital terrain model (DTM) using torch.
"mean" = mean curvature or average of profile and planform curvature; "profile" = curvature
in the direction of maximum slope; "planform" = curvature in the direction perpendicular to
the direction of maximum slope. Radii are specified using cell counts as opposed to map distance.
Gaussian smoothing using a circular window of a user-defined radius is applied prior to calculating
curvatures to minimize the impact of local noise/variability.
}
\examples{
\dontrun{
pth <- "OUTPUT PATH"
dtm <- rast(paste0(pth, "dtm.tif"))
crvPro7 <- makeCrv(dtm,
cellSize=1,
mode="profile",
smoothRadius=7,
writeRaster=TRUE,
outName=paste0(pth, "crvPro7.tif"),
device="cuda")
}
}
