% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hap2seqs.R
\name{seqs2hap}
\alias{seqs2hap}
\alias{trimSeqs}
\title{Generate Hap Results from Seqs}
\usage{
seqs2hap(
  seqs,
  Ref = names(seqs)[1],
  hetero_remove = TRUE,
  na_drop = TRUE,
  maxGapsPerSeq = 0.25,
  hapPrefix = "H",
  pad = 3,
  chrName = "Chr0",
  ...
)

trimSeqs(seqs,
         minFlankFraction = 0.1)
}
\arguments{
\item{seqs}{object of DNAStringSet or DNAMultipleAlignment class}

\item{Ref}{the name of reference sequences.
Default as the name of the first sequence}

\item{hetero_remove}{whether remove accessions contains hybrid site or not.
Default as \code{TRUE}}

\item{na_drop}{whether drop sequeces contain "N"
Default as \code{TRUE}.}

\item{maxGapsPerSeq}{value in \verb{[0, 1]} that indicates the maximum
fraction of gaps allowed in each seq after alignment (default as 0.25).
Seqs with gap percent exceed that will be dropped}

\item{hapPrefix}{prefix of hap names. Default as "H"}

\item{pad}{The number length in haplotype names should be extend to.}

\item{chrName}{the Name should be used for haplotype}

\item{...}{Parameters not used.}

\item{minFlankFraction}{A value in \verb{[0, 1]} that indicates the minimum
fraction needed to call a gap in the consensus string (default as 0.1).}
}
\value{
object of hapResult class
}
\description{
generate hapResults from aligned and trimed sequences
}
\examples{
\donttest{
data("geneHapR_test")
seqs
seqs <- trimSeqs(seqs,
         minFlankFraction = 0.1)
seqs
hapResult <- seqs2hap(seqs,
                      Ref = names(seqs)[1],
                      hetero_remove = TRUE, na_drop = TRUE,
                      maxGapsPerSeq = 0.25,
                      hapPrefix = "H")
}
}
