% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qpgee.R
\name{qpgee}
\alias{qpgee}
\alias{qpgee.formula}
\alias{qpgee.default}
\title{Quantile Penalized Generalized Estimating Equations (QPGEE)}
\usage{
qpgee(x, ...)

\method{qpgee}{formula}(x, id, data = parent.frame(), ...)

\method{qpgee}{default}(
  x,
  y,
  nobs,
  tau = 0.5,
  corstr = "exchangeable",
  lambda = NULL,
  method = "HBIC",
  intercept = TRUE,
  betaint = NULL,
  nfold = 5,
  ncore = 1,
  control = qpgeeControl(),
  ...
)
}
\arguments{
\item{x}{A matrix of predictors.}

\item{...}{Other arguments passed to methods.}

\item{id}{A vector identifying the clusters (subjects).}

\item{data}{An optional data frame.}

\item{y}{A numeric vector of response variables.}

\item{nobs}{A numeric vector of observations per subject.}

\item{tau}{The quantile to be estimated (default is 0.5).}

\item{corstr}{A string specifying the working correlation structure.
Options include "exchangeable" (Exchangeable), "AR1" (Autoregressive),
"Tri" (Tri-diagonal), "independence" (Independent), and "unstructured".}

\item{lambda}{A vector of penalty parameters. If NULL, auto-selection is performed.}

\item{method}{Criterion for penalty selection ("HBIC" or "CV").}

\item{intercept}{Logical; if TRUE, an intercept is added.}

\item{betaint}{Initial values for the beta coefficients. If NULL,
non-longitudinal quantile regression is used for initialization.}

\item{nfold}{The number of folds used in cross-validation.}

\item{ncore}{Number of cores for parallel processing.}

\item{control}{A list of control parameters from `qpgeeControl()`, such as
max_it, epsilon, shrinkCutoff, standardize and trace.}
}
\value{
An object of class `qpgee`.
}
\description{
Fits a quantile penalized generalized estimating equation (QPGEE)
model for longitudinal data using penalized quantile regression with
different working correlation structures.
}
\examples{
# Quick Example:
# 1. Generate some data
set.seed(123)
sim_data <- generate_data(
  nsub = 50, nobs = rep(5, 50), p = 10,
  beta0 = c(rep(1, 5), rep(0, 5)), rho = 0.3
)

# 2. Fit the model using the formula interface
fit <- qpgee(
  y ~ . - id,
  data = sim_data,
  id = sim_data$id,
  tau = 0.5,
  method = "HBIC"
)

# 3. View the summary of the results
summary(fit)

}
