% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/justification.R
\name{justification}
\alias{justification}
\alias{justification<-}
\title{Get or set justification for data frame columns}
\usage{
justification(x)

justification(x) <- value
}
\arguments{
\item{x}{A data frame or tibble}

\item{value}{A named list of justification values.}
}
\value{
A named list of justification values.
}
\description{
The \code{justification} function extracts all assigned justify
attributes from a 
data frame, and returns them in a named list. The function also
assigns justify attributes from a named list.
}
\details{
If justification values are assigned to the "justify" 
attributes of the data frame
columns, the \code{justification} function will extract those values.  The 
function will return the justification values in a named list, 
where the names
correspond to the name of the column that the justification was assigned to.
If a column does not have a justify attribute assigned, that column
will not be included in the list. 

When used on the receiving side of an assignment, the function will assign
justification to a data frame.  The justification values 
should be in a named list, where
each name corresponds to the name of the data frame column to assign
values to.

Finally, if you wish to clear out the justification attributes, assign
a NULL value to the \code{justification} function.
}
\examples{
# Take subset of data
df1 <- mtcars[1:5, c("mpg", "cyl") ]

# Print current state
print(df1)
#                    mpg cyl
# Mazda RX4         21.0   6
# Mazda RX4 Wag     21.0   6
# Datsun 710        22.8   4
# Hornet 4 Drive    21.4   6
# Hornet Sportabout 18.7   8

# Assign justification
justification(df1) <- list(mpg = "left", cyl = "right")
widths(df1) <- list(mpg = 12, cyl = 10)

fdata(df1)
#                            mpg        cyl
# Mazda RX4         21                    6
# Mazda RX4 Wag     21                    6
# Datsun 710        22.8                  4
# Hornet 4 Drive    21.4                  6
# Hornet Sportabout 18.7                  8

# Display justification
justification(df1)
# $mpg
# [1] "left"
# 
# $cyl
# [1] "right"

# Display widths
widths(df1)
# $mpg
# [1] 12
# 
# $cyl
# [1] 10

# Clear justification
justification(df1) <- NULL

# Confirm justifications are cleared
justification(df1)
# list()
}
\seealso{
\code{\link{fdata}} to display formatted data, 
\code{\link{value}} to create user-defined formats, and 
\code{\link{fapply}} to apply formatting to a vector.
}
