% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{fmesher_spherical_harmonics}
\alias{fmesher_spherical_harmonics}
\title{Spherical harmonics}
\usage{
fmesher_spherical_harmonics(loc, max_order, rot_inv)
}
\arguments{
\item{loc}{numeric matrix; coordinates of points to locate in the mesh}

\item{max_order}{integer; the maximum basis order}

\item{rot_inv}{logical; If \code{TRUE}, only evaluate rotationally
invariant basis functions}
}
\value{
A matrix of evaluated spherical harmonic basis functions
}
\description{
Compute spherical harmonics on the unit sphere
}
\examples{
m <- fm_rcdt_2d(globe = 1)
fmesher_spherical_harmonics(m$loc, max_order = 2, TRUE)
fmesher_spherical_harmonics(m$loc, max_order = 2, FALSE)
}
\keyword{internal}
