% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fc_theme.R
\name{fc_theme}
\alias{fc_theme}
\title{fc_theme}
\usage{
fc_theme(
  object,
  text_pattern = NULL,
  text_pattern_init = NULL,
  text_pattern_exc = NULL,
  just = NULL,
  text_color = NULL,
  text_fs = NULL,
  text_fface = NULL,
  text_ffamily = NULL,
  text_padding = NULL,
  bg_fill = NULL,
  border_color = NULL,
  width = NULL,
  height = NULL,
  just_exc = NULL,
  text_color_exc = NULL,
  text_fs_exc = NULL,
  text_fface_exc = NULL,
  text_ffamily_exc = NULL,
  text_padding_exc = NULL,
  bg_fill_exc = NULL,
  border_color_exc = NULL,
  width_exc = NULL,
  height_exc = NULL,
  text_color_title = NULL,
  text_fs_title = NULL,
  text_fface_title = NULL,
  text_ffamily_title = NULL,
  text_padding_title = NULL,
  bg_fill_title = NULL,
  border_color_title = NULL,
  width_title = NULL,
  height_title = NULL
)
}
\arguments{
\item{object}{fc object.}

\item{text_pattern}{Text pattern for all the boxes, except the initial and exclusion ones.}

\item{text_pattern_init}{Text pattern for the initial box.}

\item{text_pattern_exc}{Text pattern for the exclusion box.}

\item{just}{Justification for the text: \code{"left"}, \code{"center"} or \code{"right"}.}

\item{text_color}{Color of the text. See the \code{col} parameter for \link{gpar}.}

\item{text_fs}{Font size of the text. See the \code{fontsize} parameter for \link{gpar}.}

\item{text_fface}{Font face of the text. See the \code{fontface} parameter for \link{gpar}.}

\item{text_ffamily}{Changes the font family of the text. See the \code{fontfamily} parameter for \link{gpar}.}

\item{text_padding}{Changes the text padding inside the box. This number has to be greater than 0.}

\item{bg_fill}{Box background color. See the \code{fill} parameter for \link{gpar}.}

\item{border_color}{Box border color. See the \code{col} parameter for \link{gpar}.}

\item{width}{Width of the box. Must be an object of class \link{unit} or a number between 0 and 1.}

\item{height}{Height of the box. Must be an object of class \link{unit} or a number between 0 and 1.}

\item{just_exc}{Justification for the text of the exclude box: \code{"left"}, \code{"center"} or \code{"right"}.}

\item{text_color_exc}{Color of the text of the exclude box. See \code{text_color}.}

\item{text_fs_exc}{Font size of the text of the exclude box. See \code{text_fs}.}

\item{text_fface_exc}{Font face of the text of the exclude box. See the \code{fontface} parameter for \link{gpar}. See \code{text_fface}.}

\item{text_ffamily_exc}{Changes the font family of the text of the exclude box. See the \code{fontfamily} parameter for \link{gpar}. See \code{text_ffamily}.}

\item{text_padding_exc}{Changes the text padding inside the exclude box. This number has to be greater than 0.}

\item{bg_fill_exc}{Exclude box background color. See \code{bg_fill}.}

\item{border_color_exc}{Box background color of the exclude box. See \code{border_color}.}

\item{width_exc}{Width of the exclude box. Must be an object of class \link{unit} or a number between 0 and 1.}

\item{height_exc}{Height of the box. Must be an object of class \link{unit} or a number between 0 and 1.}

\item{text_color_title}{Color of the title text.}

\item{text_fs_title}{Font size of the title text.}

\item{text_fface_title}{Font face of the title text. See the \code{fontface} parameter for \link{gpar}.}

\item{text_ffamily_title}{Changes the font family of the title text. See the \code{fontfamily} parameter for \link{gpar}.}

\item{text_padding_title}{Changes the title text padding inside the box. This number has to be greater than 0.}

\item{bg_fill_title}{Title box background color.}

\item{border_color_title}{Title box border color.}

\item{width_title}{Width of the title box. Must be an object of class \link{unit} or a number between 0 and 1.}

\item{height_title}{Height of the title box. Must be an object of class \link{unit} or a number between 0 and 1.}
}
\value{
List with the dataset and the flowchart parameters with their modifications.
}
\description{
This function allows you to change the appearance of all boxes of a flowchart at once.
}
\examples{
safo |>
  dplyr::filter(!is.na(group)) |>
  as_fc(label = "Randomized patients") |>
  fc_split(group) |>
  fc_theme(text_fs = 11, text_color = "#324C54", text_fface = 2, bg_fill = "#ADD8E6") |>
  fc_draw()

}
