% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bkg_ags.R
\name{bkg_ags}
\alias{bkg_ags}
\alias{bkg_ars}
\title{Official keys}
\usage{
bkg_ags(..., filter = NULL, properties = NULL, max = NULL)

bkg_ars(..., filter = NULL, properties = NULL, max = NULL)
}
\arguments{
\item{...}{Used to construct CQL filters. Dot arguments accept an R-like
syntax that is converted to CQL queries internally. These queries basically
consist of a property name on the left, an aribtrary vector on the right,
and an operator that links both sides. If multiple queries are provided,
they will be chained with \code{AND}. The following operators and their
respective equivalents in CQL and XML are supported:

\tabular{lll}{
\strong{R} \tab \strong{CQL} \tab \strong{XML}\cr
\code{==} \tab \code{=} \tab \code{PropertyIsEqualTo}\cr
\code{!=} \tab \code{<>} \tab \code{PropertyIsNotEqualTo}\cr
\code{<} \tab \code{<} \tab \code{PropertyIsLessThan}\cr
\code{>} \tab \code{>} \tab \code{PropertyIsGreaterThan}\cr
\code{>=} \tab \code{>=} \tab \code{PropertyIsGreaterThanOrEqualTo}\cr
\code{<=} \tab \code{<=} \tab \code{PropertyIsLessThanOrEqualTo}\cr
\code{\%LIKE\%} \tab \code{LIKE} \tab \code{PropertyIsLike}\cr
\code{\%ILIKE\%} \tab \code{ILIKE} \tab\cr
\code{\%in\%} \tab \code{IN} \tab \code{PropertyIsEqualTo} and \code{Or}
}

To construct more complex queries, you can use the \code{filter} argument
to pass CQL queries directly. Also note that you can switch between
CQL and XML queries using \code{options(ffm_query_language = "xml")}.
See also \code{\link{wfs_filter}}.}

\item{filter}{A character string containing a valid CQL or XML filter. This
string is appended to the query constructed through \code{...}. Use this
argument to construct more complex filters. Defaults to \code{NULL}.}

\item{properties}{Vector of columns to include in the output.}

\item{max}{Maximum number of results to return.}
}
\value{
A dataframe containing the respective identifier and geographical
names related to their state, government region, district and municipality.
\code{bkg_ars} additionally returns the name of the administrative
association.
}
\description{
Retrieve geographical names associated with official municipality keys
and regional keys. To retrieve their polygon geometries, see
\code{\link{bkg_admin}}.

These functions interface the \code{wfs_gnde} product of the BKG.
}
\section{Query language}{

While other WFS interfaces like \code{\link{bkg_admin}} allow querying
using CQL or XML, \code{bkg_ags} and \code{bkg_ars} (using the GNDE service)
ONLY support XML. This has implications for the allowed query filters
(see \code{\link{wfs_filter}}).
}

\examples{
\dontshow{if (getFromNamespace("ffm_run_examples", ns = "ffm")()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Either get geographical names for identifiers
bkg_ars(ars == "01")

# ... or identifiers for geographical names
bkg_ars(gemeinde == "Köln")
\dontshow{\}) # examplesIf}
}
