% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elastic_prediction.R
\name{elastic.prediction}
\alias{elastic.prediction}
\title{Elastic Prediction from Regression Models}
\usage{
elastic.prediction(f, time, model, y = NULL, smooth_data = FALSE, sparam = 25)
}
\arguments{
\item{f}{matrix (\eqn{N} x \eqn{M}) of \eqn{M} functions with \eqn{N} samples}

\item{time}{vector of size \eqn{N} describing the sample points}

\item{model}{list describing model from elastic regression methods}

\item{y}{responses of test matrix f (default=NULL)}

\item{smooth_data}{smooth data using box filter (default = F)}

\item{sparam}{number of times to apply box filter (default = 25)}
}
\value{
Returns a list containing
\item{y_pred}{predicted values of f or probabilities depending on model}
\item{SSE}{sum of squared errors if linear}
\item{y_labels}{labels if logistic model}
\item{PC}{probability of classification if logistic}
}
\description{
This function performs prediction from an elastic regression model
with phase-variability
}
\references{
Tucker, J. D., Wu, W., Srivastava, A.,
Elastic Functional Logistic Regression with Application to Physiological Signal Classification,
Electronic Journal of Statistics (2014), submitted.
}
\keyword{alignment}
\keyword{regression}
\keyword{srvf}
