% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multiple_align_multivariate.R
\name{multiple_align_multivariate}
\alias{multiple_align_multivariate}
\title{Group-wise multivariate function alignment to specified mean}
\usage{
multiple_align_multivariate(
  beta,
  mu,
  mode = "O",
  alignment = TRUE,
  rotation = FALSE,
  scale = FALSE,
  lambda = 0,
  ncores = 1L,
  verbose = TRUE
)
}
\arguments{
\item{beta}{A numeric array of shape \eqn{L \times M \times N} specifying an
\eqn{N}-sample of \eqn{L}-dimensional functional data evaluated on a same
grid of size \eqn{M}.}

\item{mu}{array of size \eqn{L \times M} that f is aligned to}

\item{mode}{A character string specifying whether the input curves should be
considered open (\code{mode == "O"}) or closed (\code{mode == "C"}). Defaults to
\code{"O"}.}

\item{alignment}{A boolean value specifying whether the curves should be
aligned before computing the distance matrix. Defaults to \code{TRUE}.}

\item{rotation}{A boolean specifying whether the distance should be made
invariant by rotation. Defaults to \code{TRUE}.}

\item{scale}{A boolean specifying whether the distance should be made
invariant by scaling. This is effectively achieved by making SRVFs having
unit length and switching to an appropriate metric on the sphere between
normalized SRVFs. Defaults to \code{TRUE}.}

\item{lambda}{A numeric value specifying the weight of a penalty term that
constraints the warping function to be not too far from the identity.
Defaults to \code{0.0}.}

\item{ncores}{An integer value specifying the number of cores to use for
parallel computation. Defaults to \code{1L}. The maximum number of available
cores is determined by the \strong{parallel} package. One core is always left
out to avoid overloading the system.}

\item{verbose}{verbose printing (default TRUE)}
}
\value{
Returns a fdacurve object containing:
\itemize{
\item \code{beta}: A numeric array of shape \eqn{L \times M \times N} storing the
original input data.
\item \code{q}: A numeric array of shape \eqn{L \times M \times N} storing the SRVFs
of the input data.
\item \code{betan}: A numeric array of shape \eqn{L \times M \times N} storing the
aligned, possibly optimally rotated and optimally scaled, input data.
\item \code{qn}: A numeric array of shape \eqn{L \times M \times N} storing the SRVFs
of the aligned, possibly optimally rotated and optimally scaled, input data.
\item \code{gamma}: A numeric array of shape \eqn{L \times M \times N} storing the warping
functions of the aligned, possibly optimally rotated and optimally scaled, input data.
\item \code{R}: A numeric array of shape \eqn{L \times L \times N} storing the rotation
matrices of the aligned, possibly optimally rotated and optimally scaled, input data.
\item \code{betamean}: A numeric array of shape \eqn{L \times M} storing the Karcher
mean or median of the input data.
\item \code{qmean}: A numeric array of shape \eqn{L \times M} storing the Karcher mean
or median of the SRVFs of the input data.
\item \code{type}: A character string indicating whether the Karcher mean or median
has been returned.
\item \code{E}: A numeric vector storing the energy of the Karcher mean or median at
each iteration.
\item \code{qun}: A numeric vector storing the cost function of the Karcher mean or
median at each iteration.
}
}
\description{
This function aligns a collection of functions using the elastic square-root
velocity (srvf) framework.
}
\references{
Srivastava, A., Klassen, E., Joshi, S., Jermyn, I., (2011). Shape
analysis of elastic curves in euclidean spaces. IEEE Transactions on
Pattern Analysis and Machine Intelligence, \strong{33} (7), 1415-1428.
}
\keyword{alignment}
\keyword{srvf}
