% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/contrasts.R
\name{contr_code_difference}
\alias{contr_code_difference}
\title{Difference code a factor}
\usage{
contr_code_difference(fct, levels = NULL, colnames = NULL)
}
\arguments{
\item{fct}{the factor to contrast code (or a vector)}

\item{levels}{the levels of the factor in order}

\item{colnames}{optional list of column names for the added contrasts}
}
\value{
the factor with contrasts set
}
\description{
Difference coding sets the grand mean as the intercept. 
Each contrast compares one level with the previous level.
}
\examples{
df <- sim_design(between = list(pet = c("cat", "dog", "ferret")), 
                 mu = c(2, 4, 9), empirical = TRUE, plot = FALSE)
                 
df$pet <- contr_code_difference(df$pet)
lm(y ~ pet, df) \%>\% broom::tidy()

}
