% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bioclim_fast.R
\name{bioclim_fast}
\alias{bioclim_fast}
\title{Tiled, Out-of-Core Bioclimatic Variable Calculation}
\usage{
bioclim_fast(
  bios,
  n_units,
  tmin_path = NULL,
  tmax_path = NULL,
  prcp_path = NULL,
  tavg_path = NULL,
  srad_path = NULL,
  mois_path = NULL,
  period_length = 3,
  circular = TRUE,
  user_region = NULL,
  tile_degrees = 5,
  output_dir = tempdir(),
  ...
)
}
\arguments{
\item{bios}{Numeric vector of variables to compute.}

\item{n_units}{Integer, number of layers per variable.}

\item{period_length}{Integer, length of a calculation period.}

\item{circular}{Logical, whether to wrap periods.}

\item{user_region}{An `sf` or `SpatVector` object for the area of interest.}

\item{tile_degrees}{Numeric, size of processing tiles.}

\item{output_dir}{Character, path for temporary files.}

\item{...}{File paths for climate variables (e.g., `tmin_path`) and static
indices (e.g., `warmest_period_path`).}
}
\value{
Character string: Path to the temporary directory containing
  intermediate `.qs` files, to be used by an assembly function.
}
\description{
Internal function to calculate bioclimatic variables for very large datasets
by processing them in tiles. It reads data from file paths using `exactextractr`
and performs calculations with `Rfast`.
}
\seealso{
The user-facing wrapper function `derive_bioclim()`.
}
\keyword{internal}
