% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-database.R
\name{eyeris_db_summary}
\alias{eyeris_db_summary}
\title{Get summary statistics for eyeris database}
\usage{
eyeris_db_summary(bids_dir, db_path = "my-project", verbose = TRUE)
}
\arguments{
\item{bids_dir}{Path to the BIDS directory containing the database}

\item{db_path}{Database name (defaults to "my-project", becomes "my-project.eyerisdb")}

\item{verbose}{Logical. Whether to print detailed output (default TRUE)}
}
\value{
A named list containing summary information about the database contents
}
\description{
Provides a quick overview of the contents of an \code{eyeris} database,
including available subjects, sessions, tasks, and data types.
}
\examples{
\donttest{
demo_data <- eyelink_asc_demo_dataset()

demo_data |>
  eyeris::glassbox() |>
  eyeris::epoch(
    events = "PROBE_{startstop}_{trial}",
    limits = c(-1, 1),
    label = "prePostProbe"
  ) |>
  eyeris::bidsify(
    bids_dir = file.path(tempdir(), "my-cool-memory-project"),
    participant_id = "001",
    session_num = "01",
    task_name = "assocret",
    run_num = "03", # override default run-01 (block_1) to use run-03 instead
    db_enabled = TRUE,
    db_path = "my-cool-memory-study",
  )

# get database summary
summary <- eyeris_db_summary(
             file.path(
               tempdir(),
               "my-cool-memory-project"
             ),
             db_path = "my-cool-memory-study"
           )

# view available subjects
summary$subjects

# view available data types
summary$data_types

# view table counts
summary$table_counts
}

}
