% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/abtest.R
\name{abtest_targetpct}
\alias{abtest_targetpct}
\title{A/B testing comparing percent per group}
\usage{
abtest_targetpct(
  data,
  expr,
  n,
  target,
  sign_level = 0.05,
  group_label,
  ab_label = FALSE,
  color = "grey"
)
}
\arguments{
\item{data}{A dataset}

\item{expr}{Expression, that results in a FALSE/TRUE}

\item{n}{A Variable for number of observations (count data)}

\item{target}{Target variable (must be 0/1 or FALSE/TRUE)}

\item{sign_level}{Significance Level (typical 0.01/0.05/0.10)}

\item{group_label}{Label of groups (default = expr)}

\item{ab_label}{Label Groups as A and B (default = FALSE)}

\item{color}{color of bar}
}
\value{
Plot that shows if difference is significant
}
\description{
A/B testing comparing percent per group
}
\examples{
data <- create_data_buy(obs = 100)
abtest(data, female_ind == 1, target = buy)
abtest(data, age >= 40, target = buy)
}
