% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/00_exametrikaPlot.R
\name{plot.exametrika}
\alias{plot.exametrika}
\title{Plot Method for Objects of Class "exametrika"}
\usage{
\method{plot}{exametrika}(
  x,
  type = c("IRF", "TRF", "IIF", "TIF", "IIC", "ICC", "TIC", "IRP", "TRP", "LCD", "CMP",
    "FRP", "RMP", "LRD", "Array", "CRV", "RRV", "FieldPIRP", "LDPSR", "ScoreFreq",
    "ScoreRank", "ICRP", "ICBR"),
  items = NULL,
  students = NULL,
  nc = 1,
  nr = 1,
  overlay = FALSE,
  colors = NULL,
  cell_width = 3,
  cell_height = 1,
  filename = NULL,
  width = 800,
  height = 600,
  dpi = 300,
  ...
)
}
\arguments{
\item{x}{An object of class "exametrika"}

\item{type}{Character string specifying the plot type. Available types vary by model:
\describe{
\item{IRF, ICC}{Item Response Function. Also known as 'ICC' (Item Characteristic Curve).}
\item{TRF}{Test Response Function.}
\item{IIF, IIC}{Item Information Function. Also known as 'IIC' (Item Information Curve).}
\item{TIF, TIC}{Test Information Function. Also known as 'TIC' (Test Information Curve).}
\item{IRP}{Item Reference Profile. Line graph with items and latent classes/ranks
on the horizontal axis, and membership probability on the vertical axis.}
\item{CRV, RRV}{Class/Rank Reference Vector. Plots correct answer rates for each class or rank,
with fields on the horizontal axis and correct answer rates on the vertical axis.}
\item{TRP}{Test Reference Profile. Shows latent classes/ranks on the horizontal axis,
displaying members per class/rank as a bar graph and expected test scores as a line graph.}
\item{LCD}{Latent Class Distribution. Displays latent classes on the horizontal axis,
showing members per class as a bar graph and cumulative membership probability as a line.}
\item{LRD}{Latent Rank Distribution. Similar to LCD but with ranks instead of classes on the horizontal axis.}
\item{CMP}{Class Membership Profile. Line graph showing class membership probabilities of students.}
\item{RMP}{Rank Membership Profile. Similar to CMP but with ranks instead of classes.}
\item{ScoreFreq}{Frequency polygon of score distribution with rank thresholds.}
\item{ScoreRank}{Heatmap of score membership probabilities for each rank.}
\item{ICRP}{Visualizes ranks (x-axis) versus category response probabilities (y-axis).}
\item{ICBR}{Visualizes ranks (x-axis) versus cumulative category probabilities (y-axis).}
\item{FRP}{Field Reference Profile. Shows correspondence between fields and latent classes/ranks.}
\item{Array}{Array plot for Biclustering/Ranklustering. Colored matrix cells where darker cells
indicate larger values.}
\item{FieldPIRP}{Shows correct response rates by number of correct answers in parent fields.
Only available for LDB model.}
\item{LDPSR}{Latent Dependence Passing Student Rate. Compares passing rates of parent and child classes.}
}}

\item{items}{Numeric vector specifying which items to plot. If NULL, all items are included.
When type is "IIF"/"IIC", specifying 0 will produce a TIF/TIC for the entire test.}

\item{students}{Numeric vector specifying which students to plot. If NULL, all students are included.}

\item{nc}{Integer specifying the number of columns for multiple plots. Default is 1.}

\item{nr}{Integer specifying the number of rows for multiple plots. Default is 1.}

\item{overlay}{Logical. If TRUE, elements such as IRFs will be overlaid on a single plot. Default is FALSE.}

\item{colors}{Character vector specifying custom color palette. If NULL, default colorblind-friendly palette is used.
For array plots, the first color should be for missing values, followed by response category colors.}

\item{cell_width}{Numeric value specifying the width of each cell in array plots. Default is 3.}

\item{cell_height}{Numeric value specifying the height of each cell in array plots. Default is 1.}

\item{filename}{Character string specifying output filename. If NULL, plot is displayed on screen.
Supported formats: png, pdf, jpeg, jpg. Format determined by file extension.}

\item{width}{Numeric value specifying plot width in pixels (for png/jpeg) or inches (for pdf). Default is 800.}

\item{height}{Numeric value specifying plot height in pixels (for png/jpeg) or inches (for pdf). Default is 600.}

\item{dpi}{Numeric value specifying resolution in dots per inch for raster formats (png/jpeg). Default is 300.}

\item{...}{Additional arguments passed to plotting functions.}
}
\value{
Produces visualizations based on the model class and specified type:

\describe{
\item{IRT models}{IRF (Item Response Function), TRF (Test Response Function),
IIF (Item Information Function), TIF (Test Information Function)}
\item{LCA/LRA models}{IRP (Item Reference Profile), TRP (Test Reference Profile),
LCD/LRD (Latent Class/Rank Distribution), CMP/RMP (Class/Rank Membership Profile)}
\item{Biclustering/IRM models}{Array plots showing clustering patterns, FRP, TRP, etc.}
\item{LDLRA/LDB/BINET models}{Network and profile plots specific to each model}
}
}
\description{
Creates visualizations for objects with class "exametrika".
The calculation results of the exametrika package have an exametrika class attribute,
along with the specific analysis model class (IRT, GRM, LCA, LRA, Biclustering, IRM, LDLRA, LDB,
BINET). Each model has its own compatible plot types, accessible by specifying the 'type' parameter.
}
\details{
Each model class supports specific plot types:

\describe{
\item{IRT}{Supports "IRF"/"ICC", "TRF", "IIF"/"IIC", "TIF"/"TIC"}
\item{GRM}{Supports "IRF"/"ICC", "IIF"/"IIC", "TIF"/"TIC"}
\item{LCA}{Supports "IRP", "FRP", "TRP", "LCD", "CMP"}
\item{LRA}{Supports "IRP", "FRP", "TRP", "LRD", "RMP"}
\item{LRAordinal}{Supports "ScoreFreq", "ScoreRank", "ICRP", "ICBR", "RMP"}
\item{LRArated}{Supports "ScoreFreq", "ScoreRank", "ICRP", "RMP"}
\item{Biclustering}{Supports "FRP", "TRP", "LCD", "LRD", "CMP", "RMP", "CRV", "RRV", "Array"}
\item{IRM}{Supports "FRP", "TRP", "Array"}
\item{LDLRA}{Supports "IRP", "TRP", "LRD", "RMP"}
\item{LDB}{Supports "FRP", "TRP", "LRD", "RMP", "Array", "FieldPIRP"}
\item{BINET}{Supports "FRP", "TRP", "LRD", "RMP", "Array", "LDPSR"}
}
}
\examples{
\dontrun{
# IRT model example
irt_result <- exametrika::IRT(J15S500)
plot(irt_result, type = "IRF", items = 1:5)
plot(irt_result, type = "TIF")

# LCA model example
lca_result <- exametrika::LCA(U)
plot(lca_result, type = "IRP")
plot(lca_result, type = "LCD")
}

# Array plot with custom output
biclustering_result <- exametrika::Biclustering(J35S515)
# Custom colors and file output
my_colors <- c("#404040", "#E69F00", "#56B4E9", "#009E73", "#F0E442")
plot(biclustering_result, type = "Array", colors = my_colors)

}
