% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/02_TestItemFunctions.R
\name{PolychoricCorrelationMatrix}
\alias{PolychoricCorrelationMatrix}
\alias{PolychoricCorrelationMatrix.default}
\alias{PolychoricCorrelationMatrix.ordinal}
\title{Polychoric Correlation Matrix}
\usage{
PolychoricCorrelationMatrix(U, na = NULL, Z = NULL, w = NULL)

\method{PolychoricCorrelationMatrix}{default}(U, na = NULL, Z = NULL, w = NULL)

\method{PolychoricCorrelationMatrix}{ordinal}(U, na = NULL, Z = NULL, w = NULL)
}
\arguments{
\item{U}{Either an object of class "exametrika" or raw data. When raw data is given,
it is converted to the exametrika class with the \code{\link{dataFormat}} function.}

\item{na}{Values to be treated as missing values.}

\item{Z}{Missing indicator matrix of type matrix or data.frame. Values of 1 indicate
observed responses, while 0 indicates missing data.}

\item{w}{Item weight vector specifying the relative importance of each item.}
}
\value{
A matrix of polychoric correlations with exametrika class.
Each element (i,j) represents the polychoric correlation between items i and j.
The matrix is symmetric with ones on the diagonal.
}
\description{
Polychoric Correlation Matrix
}
\examples{
\donttest{
# example code
PolychoricCorrelationMatrix(J5S1000)
}
}
