% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BarPlotCat.R
\name{BarPlotCat}
\alias{BarPlotCat}
\title{Plot Bar Charts of Forecast Category Probabilities}
\usage{
BarPlotCat(
  probs,
  lims,
  extreme_probs = NULL,
  extreme_lims = NULL,
  skill = NULL,
  toptitle = "",
  legend_title = "",
  cat_dim = "cat",
  panel_dim = "ftime",
  color.set = "s2s4e",
  category_names = c("bn", "norn", "an"),
  panel_title = "",
  panel_subtitle = "",
  panel_bottom_name = "",
  lims_pos = -4,
  legend_width = 3.5,
  extreme_bars_width = 0.4,
  xaxis_title = "",
  extreme_cat_names = c("p10", "p90"),
  toptitle_size = 16,
  toptitle_pos = "center",
  fileout = NULL,
  width = 8,
  height = 6,
  size_units = NULL,
  res = 100
)
}
\arguments{
\item{probs}{A named 2D array with dimensions 'cat_dim' × 'panel_dim', 
containing probabilities for each category (in relative units, summing to 1).
Can also be a named vector (recycled to 2D internally).}

\item{lims}{A named 2D array with category threshold values (e.g., tercile 
cutoffs), or a vector with length one less than the category dimension of
'probs'. Should match the shape and names of 'probs'.}

\item{extreme_probs}{(optional) A 2D array (or vector) with probabilities for
extreme categories (e.g., below P10, above P90), with dimensions matching 
'probs'.}

\item{extreme_lims}{(optional) A 2D array (or vector) with limits corresponding
to the extreme categories.}

\item{skill}{(optional) A numeric vector indicating skill scores for each 
panel. Used to reduce bar transparency if negative.}

\item{toptitle}{A character string with the main plot title.}

\item{legend_title}{A string with the title of the legend that shows the 
categories.}

\item{cat_dim}{A string indicating the name of the category dimension. 
Default is "cat".}

\item{panel_dim}{A string indicating the name of the panel dimension (e.g., 
time). Default is "ftime".}

\item{color.set}{A string selecting the color palette to use. One of 
\code{"s2s4e"}, \code{"ggplot"}, \code{"hydro"}, \code{"vitigeoss"}. Default
is "s2s4e".}

\item{category_names}{A character vector with names for each forecast category.
Default is \code{c("bn", "norn", "an")}.}

\item{panel_title}{A string or vector of strings with titles for each panel.
If one value, it is repeated across panels.}

\item{panel_subtitle}{A string or vector with subtitles for each panel. If one
value, it is repeated across panels.}

\item{panel_bottom_name}{A string or vector for the bottom axis label of each
panel.}

\item{lims_pos}{A numeric value indicating the vertical position of threshold
annotations. Default is -1.5.}

\item{legend_width}{A numeric value (in cm) for the width of the legend area.
Default is 3.}

\item{extreme_bars_width}{A numeric value between 0 and 1 defining the width
of the bars for extreme categories. Default is 0.4.}

\item{xaxis_title}{A string for the shared x-axis title.}

\item{extreme_cat_names}{A character vector with names for the extreme
categories (left and right). Default is \code{c("p10", "p90")}.}

\item{toptitle_size}{A numeric value for the font size of the top title.
Default is 16.}

\item{toptitle_pos}{A string for justification of the title. One of 
\code{"left"}, \code{"center"}, \code{"right"}. Default is "center".}

\item{fileout}{(optional) Path to save the resulting plot (e.g.,
\code{"plot.png"}). If NULL, the plot is returned.}

\item{width}{(optional) Width of the output figure, passed to 
\code{ggsave()}. Units are defined by 'size_units'.}

\item{height}{(optional) Height of the output figure, passed to 
\code{ggsave()}. Units are defined by 'size_units'.}

\item{size_units}{Units for \code{width} and \code{height}. Default is inches.
See \code{ggsave()}.}

\item{res}{Plot resolution in dpi when saving to file. Default is NULL.}
}
\value{
A grob object representing the composed bar plot, invisibly if written
 to file.
}
\description{
This function creates bar plots for probabilistic forecasts split into 
categories (e.g., below-normal, normal, above-normal), optionally including
extreme categories (e.g., below P10, above P90). Probabilities are displayed 
on the y-axis. The function supports multi-panel plotting for different time
steps, the addition of skill-based transparency, a shared legend and axis
title, and output to file.
}
\examples{
# Basic example
probs <- array(rep(c(0.3, 0.4, 0.3), 4), c(cat = 3, ftime = 4))
lims <- array(rep(c(2, 4), 4), c(cat = 2, ftime = 4))
BarPlotCat(probs, lims, toptitle = "Example Forecast")

}
