% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tracktimes.R
\name{tracktimes}
\alias{tracktimes}
\title{Get the track times from EMU trackdata objects}
\usage{
tracktimes(trackdata)
}
\arguments{
\item{trackdata}{An EMU trackdata object, or a matrix of track values
obtained at a single time point using dcut()}
}
\description{
The function obtains the times at which track values occur.
}
\details{
Every $data value in a trackdata object is associated with a time at which
it occurs in the utterance. This function returns those times.
}
\examples{

# track time values for a trackdata object
times <- tracktimes(vowlax.fdat)
# track time values for a matrix of trackdata values
# at  the temporal midpoint
tracktimes(dcut(vowlax.fdat[1:3,], 0.5, prop=TRUE))

}
\seealso{
\code{\link{start.trackdata}} \code{\link{end.trackdata}}
\code{\link{start.emusegs}} \code{\link{end.emusegs}}
}
\author{
Jonathan Harrington
}
\keyword{datagen}
