% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elm.R
\name{elm}
\alias{elm}
\title{Fit an extreme learning model}
\usage{
elm(
  formula,
  data,
  nhid,
  actfun,
  init_weights = "normal_gaussian",
  bias = FALSE,
  moorep_pseudoinv_tol = 0.01,
  leaky_relu_alpha = 0,
  seed = 1,
  verbose = FALSE
)
}
\arguments{
\item{formula}{formula used to specify the regression or classification.}

\item{data}{data.frame with the data}

\item{nhid}{a numeric value specifying the hidden neurons. Must be >= 1}

\item{actfun}{a character string specifying the type of activation function. It should be one of the following : 'sig' \emph{( sigmoid )}, 'sin' \emph{( sine )}, 'radbas' \emph{( radial basis )}, 'hardlim' \emph{( hard-limit )}, 'hardlims' \emph{( symmetric hard-limit )}, 'satlins' \emph{( satlins )}, 'tansig' \emph{( tan-sigmoid )}, 'tribas' \emph{( triangular basis )}, 'relu' \emph{( rectifier linear unit )} or 'purelin' \emph{( linear )}}

\item{init_weights}{a character string spcecifying the distribution from which the \emph{input-weights} and the \emph{bias} should be initialized. It should be one of the following : 'normal_gaussian' \emph{(normal / Gaussian distribution with zero mean and unit variance)}, 'uniform_positive' \emph{( in the range [0,1] )} or 'uniform_negative' \emph{( in the range [-1,1] )}}

\item{bias}{either TRUE or FALSE. If TRUE then \emph{bias} weights will be added to the hidden layer}

\item{moorep_pseudoinv_tol}{a numeric value. See the references web-link for more details on \emph{Moore-Penrose pseudo-inverse} and specifically on the \emph{pseudo inverse tolerance value}}

\item{leaky_relu_alpha}{a numeric value between 0.0 and 1.0. If 0.0 then a simple \emph{relu} ( f(x) = 0.0 for x < 0, f(x) = x for x >= 0 ) activation function will be used, otherwise a \emph{leaky-relu} ( f(x) = alpha * x for x < 0, f(x) = x for x >= 0 ). It is applicable only if \emph{actfun} equals to 'relu'}

\item{seed}{a numeric value specifying the random seed. Defaults to 1}

\item{verbose}{a boolean. If TRUE then information will be printed in the console}
}
\value{
elm object which can be used with predict, residuals and fitted.
}
\description{
Formula interface for \code{\link{elm_train}}, transforms a data frame and formula
into the necessary input for elm_train, automatically calls \code{\link{onehot_encode}}
for classification.
}
\examples{
elm(Species ~ ., data = iris, nhid = 20, actfun="sig")

mod_elm <- elm(Species ~ ., data = iris, nhid = 20, actfun="sig")

# predict classes
predict(mod_elm, newdata = iris[1:3,-5])

# predict probabilities
predict(mod_elm, newdata = iris[1:3,-5], type="prob")

# predict elm output
predict(mod_elm, newdata = iris[1:3,-5], type="raw")

data("Boston")
elm(medv ~ ., data = Boston, nhid = 40, actfun="relu")

data("ionosphere")
elm(class ~ ., data = ionosphere, nhid=20, actfun="relu")

}
