% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/thresh.R
\name{thresh}
\alias{thresh}
\title{A function to return the maximum percentage of the cumulative sum represented 
by a subset of the vector}
\usage{
thresh(x, cutoff, na.rm = TRUE)
}
\arguments{
\item{x}{a numeric vector, missing values are allowed}

\item{cutoff}{numeric, the number of elements to look at}

\item{na.rm}{logical, should missing values be excluded?}
}
\value{
A numeric proportion
}
\description{
Returns the proportion of the cumulative sum represented by the 
number of elements in the vector a user specifies. This allows the user to 
identify the maximum proportion of the total that only X number of elements 
may represent in the vector.
}
\details{
Calculates the proportion of a numeric vector reached after sorting 
the vector in ascending order and stopping at the specified count
}
\examples{
# for vector
a <- rnorm(100, mean=6, sd=1)
thresh(a, 8) #return minimum number of elements to account 70 percent of total
}
\seealso{
\code{\link{cutoff}} which this function is related to
}
\author{
Jared E. Knowles
}
