% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/risk.R
\name{risk}
\alias{risk}
\title{Calculate Risk Scores Using Expert-Based or Model-Derived Vulnerability
and Status Scores}
\usage{
risk(vulnerability_results, status_results)
}
\arguments{
\item{vulnerability_results}{A data frame with the output from the
\code{vulnerability} function.}

\item{status_results}{A data frame with status scores for each state indicator.
The first column MUST contain the indicator names.
The second and third column have to be named status and score.}
}
\value{
a data frame containing the exposure, sensitivity, adaptive capacity,
vulnerability, and risk scores as well as their associated uncertainty for
each pressure - state indicator - type combination.
}
\description{
The \code{risk} function calculates risk scores using the output from of the
\code{\link{status}} and the \code{\link{vulnerability}} functions.
For each state indicator-pressure combination the function adds the status
score to the vulnerability score to derive the risk score.
}
\details{
Final risk scores are in a range from -10 (severe risk for the state
indicator due to the assessed pressure) to +10 (good opportunities for the
state indicator due to the assessed pressure). The risk scores are specific for
each combination of state indicator and pressure and do NOT take into account
cumulative effects. The risk scores can be aggregated in an additive manner
with the \code{\link{aggregate_risk}} function.
}
\examples{
# Using demo output data from the vulnerability() and status() functions:
risk(
  vulnerability_results = ex_output_vulnerability_model,
  status_results = ex_output_status
)

\donttest{
  ### Demo Expert-Based Pathway
  # - using the example scoring datasets 'ex_expert_exposure',
  #   'ex_expert_sensitivity' and 'ex_expert_status'

  # Calculate (mean) exposure score:
  exp_expert <- calc_exposure(
    pressures = ex_expert_exposure$pressure,
    components = ex_expert_exposure[ ,2:5],
    uncertainty = ex_expert_exposure[ ,6:9],
    method = "mean" # default
  )
  # Calculate (mean) sensitivity (and adaptive capacity) score:
  sens_ac_expert <- calc_sensitivity(
    indicators = ex_expert_sensitivity$indicator,
    pressures = ex_expert_sensitivity$pressure,
    type = ex_expert_sensitivity$type,
    sensitivity_traits = ex_expert_sensitivity[ ,4:8],
    adaptive_capacities = ex_expert_sensitivity[ ,9:13],
    uncertainty_sens = ex_expert_sensitivity[ ,14:18],
    uncertainty_ac = ex_expert_sensitivity[ ,19:23],
    method = "mean" # default
  )
  # Calculate (mean) vulnerability score:
  vuln_expert <- vulnerability(
    exposure_results = exp_expert,
    sensitivity_results = sens_ac_expert,
    method_vulnerability = "mean", # default
    method_uncertainty = "mean" # default
  )
  # Calculate risk score:
  risk(
    vulnerability_results = vuln_expert,
    status_results = ex_expert_status
  )


  ### Demo Model-Based Pathway
  # - using the demo time series 'pressure_ts_baltic' and 'indicator_ts_baltic'

  # Model exposure score:
  exp_model <- model_exposure(
    pressure_time_series = pressure_ts_baltic,
    base_years = c(start = 1984, end = 1994),
    current_years = c(start = 2010, end = 2016)
  )

  # Model sensitivity score:
  sens_ac_model <- model_sensitivity(
    indicator_time_series = indicator_ts_baltic,
    pressure_time_series = pressure_ts_baltic,
    current_years = c(start = 2010, end = 2016)
  )
  # Add manually adaptive capacity scores (otherwise zero):
  sens_ac_model$adaptive_capacity <- c(rep(1, 8), rep(-1, 8))

  # Calculate (mean) vulnerability score:
  vuln_model <- vulnerability(
    exposure_results = exp_model,
    sensitivity_results = sens_ac_model
  )
  # Calculate status score:
  status_model <- status(
    indicator_time_series = indicator_ts_baltic,
    base_years = c(start = 1984, end = 2010),
    current_years = c(start = 2011, end = 2016)
  )
  # Calculate risk score:
  risk(
    vulnerability_results = vuln_model,
    status_results = status_model
  )

}
}
\seealso{
\code{\link{vulnerability}}, \code{\link{status}}, \code{\link{aggregate_risk}}
}
